/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.parser;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.expression.Order;
import org.elasticsearch.xpack.sql.expression.UnresolvedAlias;
import org.elasticsearch.xpack.sql.parser.ExpressionBuilder;
import org.elasticsearch.xpack.sql.parser.ParsingException;
import org.elasticsearch.xpack.sql.parser.SqlBaseParser;
import org.elasticsearch.xpack.sql.plan.TableIdentifier;
import org.elasticsearch.xpack.sql.plan.logical.Aggregate;
import org.elasticsearch.xpack.sql.plan.logical.Distinct;
import org.elasticsearch.xpack.sql.plan.logical.Filter;
import org.elasticsearch.xpack.sql.plan.logical.Join;
import org.elasticsearch.xpack.sql.plan.logical.Limit;
import org.elasticsearch.xpack.sql.plan.logical.LocalRelation;
import org.elasticsearch.xpack.sql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.sql.plan.logical.OrderBy;
import org.elasticsearch.xpack.sql.plan.logical.Project;
import org.elasticsearch.xpack.sql.plan.logical.SubQueryAlias;
import org.elasticsearch.xpack.sql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.sql.plan.logical.With;
import org.elasticsearch.xpack.sql.plugin.SqlTypedParamValue;
import org.elasticsearch.xpack.sql.session.EmptyExecutable;
import org.elasticsearch.xpack.sql.type.DataType;

abstract class LogicalPlanBuilder
extends ExpressionBuilder {
    protected LogicalPlanBuilder(Map<Token, SqlTypedParamValue> params) {
        super(params);
    }

    @Override
    public LogicalPlan visitQuery(SqlBaseParser.QueryContext ctx) {
        LogicalPlan body = this.plan((ParseTree)ctx.queryNoWith());
        List<SubQueryAlias> namedQueries = this.visitList(ctx.namedQuery(), SubQueryAlias.class);
        LinkedHashMap<String, SubQueryAlias> cteRelations = new LinkedHashMap<String, SubQueryAlias>(namedQueries.size());
        for (SubQueryAlias namedQuery : namedQueries) {
            if (cteRelations.put(namedQuery.alias(), namedQuery) == null) continue;
            throw new ParsingException(namedQuery.location(), "Duplicate alias {}", namedQuery.alias());
        }
        return new With(LogicalPlanBuilder.source(ctx), body, cteRelations);
    }

    @Override
    public LogicalPlan visitNamedQuery(SqlBaseParser.NamedQueryContext ctx) {
        return new SubQueryAlias(LogicalPlanBuilder.source(ctx), this.plan((ParseTree)ctx.queryNoWith()), ctx.name.getText());
    }

    @Override
    public LogicalPlan visitQueryNoWith(SqlBaseParser.QueryNoWithContext ctx) {
        LogicalPlan plan = this.plan((ParseTree)ctx.queryTerm());
        if (!ctx.orderBy().isEmpty()) {
            plan = new OrderBy(LogicalPlanBuilder.source(ctx.ORDER()), plan, this.visitList(ctx.orderBy(), Order.class));
        }
        if (ctx.limit != null && ctx.INTEGER_VALUE() != null) {
            plan = new Limit(LogicalPlanBuilder.source(ctx.limit), new Literal(LogicalPlanBuilder.source(ctx), Integer.parseInt(ctx.limit.getText()), DataType.INTEGER), plan);
        }
        return plan;
    }

    @Override
    public LogicalPlan visitQuerySpecification(SqlBaseParser.QuerySpecificationContext ctx) {
        SqlBaseParser.GroupByContext groupByCtx;
        LogicalPlan query = ctx.fromClause() == null ? new LocalRelation(LogicalPlanBuilder.source(ctx), new EmptyExecutable(Collections.emptyList())) : this.plan((ParseTree)ctx.fromClause());
        if (ctx.where != null) {
            query = new Filter(LogicalPlanBuilder.source(ctx), query, this.expression((ParseTree)ctx.where));
        }
        List selectTarget = Collections.emptyList();
        if (!ctx.selectItem().isEmpty()) {
            selectTarget = this.expressions(ctx.selectItem()).stream().map(e -> e instanceof NamedExpression ? (NamedExpression)e : new UnresolvedAlias(e.location(), (Expression)e)).collect(Collectors.toList());
        }
        if ((groupByCtx = ctx.groupBy()) != null) {
            TerminalNode groupByAll;
            SqlBaseParser.SetQuantifierContext setQualifierContext = groupByCtx.setQuantifier();
            TerminalNode terminalNode = groupByAll = setQualifierContext == null ? null : setQualifierContext.ALL();
            if (groupByAll != null) {
                throw new ParsingException(LogicalPlanBuilder.source(groupByAll), "GROUP BY ALL is not supported", new Object[0]);
            }
            List<Expression> groupBy = this.expressions(groupByCtx.groupingElement());
            query = new Aggregate(LogicalPlanBuilder.source(groupByCtx), query, groupBy, selectTarget);
        } else if (!selectTarget.isEmpty()) {
            query = new Project(LogicalPlanBuilder.source(ctx.selectItem(0)), query, selectTarget);
        }
        if (ctx.having != null) {
            query = new Filter(LogicalPlanBuilder.source(ctx.having), query, this.expression((ParseTree)ctx.having));
        }
        if (ctx.setQuantifier() != null && ctx.setQuantifier().DISTINCT() != null) {
            query = new Distinct(LogicalPlanBuilder.source(ctx.setQuantifier()), query);
        }
        return query;
    }

    @Override
    public LogicalPlan visitFromClause(SqlBaseParser.FromClauseContext ctx) {
        List<LogicalPlan> plans = this.plans(ctx.relation());
        return (LogicalPlan)plans.stream().reduce((left, right) -> new Join(LogicalPlanBuilder.source(ctx), (LogicalPlan)left, (LogicalPlan)right, Join.JoinType.IMPLICIT, null)).get();
    }

    @Override
    public LogicalPlan visitRelation(SqlBaseParser.RelationContext ctx) {
        LogicalPlan result = this.plan((ParseTree)ctx.relationPrimary());
        for (SqlBaseParser.JoinRelationContext j : ctx.joinRelation()) {
            result = this.doJoin(result, j);
        }
        return result;
    }

    private Join doJoin(LogicalPlan left, SqlBaseParser.JoinRelationContext ctx) {
        SqlBaseParser.JoinTypeContext joinType = ctx.joinType();
        Join.JoinType type = Join.JoinType.INNER;
        if (joinType != null) {
            if (joinType.FULL() != null) {
                type = Join.JoinType.FULL;
            }
            if (joinType.LEFT() != null) {
                type = Join.JoinType.LEFT;
            }
            if (joinType.RIGHT() != null) {
                type = Join.JoinType.RIGHT;
            }
        }
        Expression condition = null;
        SqlBaseParser.JoinCriteriaContext criteria = ctx.joinCriteria();
        if (criteria != null) {
            if (criteria.USING() != null) {
                throw new UnsupportedOperationException();
            }
            if (criteria.booleanExpression() != null) {
                condition = this.expression((ParseTree)criteria.booleanExpression());
            }
        }
        throw new ParsingException(LogicalPlanBuilder.source(ctx), "Queries with JOIN are not yet supported", new Object[0]);
    }

    @Override
    public Object visitAliasedRelation(SqlBaseParser.AliasedRelationContext ctx) {
        return new SubQueryAlias(LogicalPlanBuilder.source(ctx), this.plan((ParseTree)ctx.relation()), this.visitQualifiedName(ctx.qualifiedName()));
    }

    @Override
    public Object visitAliasedQuery(SqlBaseParser.AliasedQueryContext ctx) {
        return new SubQueryAlias(LogicalPlanBuilder.source(ctx), this.plan((ParseTree)ctx.queryNoWith()), this.visitQualifiedName(ctx.qualifiedName()));
    }

    @Override
    public Object visitSubquery(SqlBaseParser.SubqueryContext ctx) {
        return this.plan((ParseTree)ctx.queryNoWith());
    }

    @Override
    public LogicalPlan visitTableName(SqlBaseParser.TableNameContext ctx) {
        String alias = this.visitQualifiedName(ctx.qualifiedName());
        TableIdentifier tableIdentifier = this.visitTableIdentifier(ctx.tableIdentifier());
        return new UnresolvedRelation(LogicalPlanBuilder.source(ctx), tableIdentifier, alias);
    }
}

