/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.arithmetic;

import java.util.Locale;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.expression.function.scalar.arithmetic.BinaryArithmeticProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.arithmetic.BinaryArithmeticProcessorDefinition;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.BinaryNumericFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.ProcessorDefinition;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.ProcessorDefinitions;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;

public abstract class ArithmeticFunction
extends BinaryNumericFunction {
    private final BinaryArithmeticProcessor.BinaryArithmeticOperation operation;

    ArithmeticFunction(Location location, Expression left, Expression right, BinaryArithmeticProcessor.BinaryArithmeticOperation operation) {
        super(location, left, right);
        this.operation = operation;
    }

    public BinaryArithmeticProcessor.BinaryArithmeticOperation operation() {
        return this.operation;
    }

    @Override
    public DataType dataType() {
        return DataTypeConversion.commonType(this.left().dataType(), this.right().dataType());
    }

    @Override
    protected ScriptTemplate asScriptFrom(ScriptTemplate leftScript, ScriptTemplate rightScript) {
        String op = this.operation.symbol();
        if (this.operation == BinaryArithmeticProcessor.BinaryArithmeticOperation.MOD) {
            op = "%" + op;
        }
        return new ScriptTemplate(String.format(Locale.ROOT, "(%s) %s (%s)", leftScript.template(), op, rightScript.template()), ParamsBuilder.paramsBuilder().script(leftScript.params()).script(rightScript.params()).build(), this.dataType());
    }

    @Override
    protected ProcessorDefinition makeProcessorDefinition() {
        return new BinaryArithmeticProcessorDefinition(this.location(), this, ProcessorDefinitions.toProcessorDefinition(this.left()), ProcessorDefinitions.toProcessorDefinition(this.right()), this.operation);
    }

    @Override
    public String name() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.left());
        if (!(this.left() instanceof Literal)) {
            sb.insert(1, "(");
            sb.append(")");
        }
        sb.append(" ");
        sb.append(this.operation);
        sb.append(" ");
        int pos = sb.length();
        sb.append(this.right());
        if (!(this.right() instanceof Literal)) {
            sb.insert(pos, "(");
            sb.append(")");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.name() + "#" + this.functionId();
    }

    protected boolean useParanthesis() {
        return !(this.left() instanceof Literal) || !(this.right() instanceof Literal);
    }
}

