/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.io.IOException;
import java.time.Instant;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authc.Authentication;

public final class UserToken
implements Writeable,
ToXContentObject {
    private final Version version;
    private final String id;
    private final Authentication authentication;
    private final Instant expirationTime;
    private final Map<String, Object> metadata;

    UserToken(Authentication authentication, Instant expirationTime) {
        this(Version.CURRENT, authentication, expirationTime, Collections.emptyMap());
    }

    UserToken(Version version, Authentication authentication, Instant expirationTime, Map<String, Object> metadata) {
        this(UUIDs.randomBase64UUID(), version, authentication, expirationTime, metadata);
    }

    UserToken(String id, Version version, Authentication authentication, Instant expirationTime, Map<String, Object> metadata) {
        this.version = Objects.requireNonNull(version);
        this.id = Objects.requireNonNull(id);
        this.authentication = Objects.requireNonNull(authentication);
        this.expirationTime = Objects.requireNonNull(expirationTime);
        this.metadata = metadata;
    }

    UserToken(StreamInput input) throws IOException {
        this.version = input.getVersion();
        this.id = input.readString();
        this.authentication = new Authentication(input);
        this.expirationTime = Instant.ofEpochSecond(input.readLong(), input.readInt());
        this.metadata = this.version.before(Version.V_6_2_0) ? Collections.emptyMap() : input.readMap();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        this.authentication.writeTo(out);
        out.writeLong(this.expirationTime.getEpochSecond());
        out.writeInt(this.expirationTime.getNano());
        if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            out.writeMap(this.metadata);
        }
    }

    Authentication getAuthentication() {
        return this.authentication;
    }

    Instant getExpirationTime() {
        return this.expirationTime;
    }

    public String getId() {
        return this.id;
    }

    Version getVersion() {
        return this.version;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.id);
        builder.field("expiration_time", this.expirationTime.toEpochMilli());
        builder.field("version", this.version.id);
        builder.field("metadata", this.metadata);
        try (BytesStreamOutput output = new BytesStreamOutput();){
            output.setVersion(this.version);
            this.authentication.writeTo((StreamOutput)output);
            builder.field("authentication", output.bytes().toBytesRef().bytes);
        }
        return builder.endObject();
    }

    static UserToken fromSourceMap(Map<String, Object> source) throws IOException {
        String id = (String)source.get("id");
        Long expirationEpochMilli = (Long)source.get("expiration_time");
        Integer versionId = (Integer)source.get("version");
        Map metadata = (Map)source.get("metadata");
        String authString = (String)source.get("authentication");
        Version version = Version.fromId((int)versionId);
        try (StreamInput in = StreamInput.wrap((byte[])Base64.getDecoder().decode(authString));){
            in.setVersion(version);
            Authentication authentication = new Authentication(in);
            UserToken userToken = new UserToken(id, version, authentication, Instant.ofEpochMilli(expirationEpochMilli), metadata);
            return userToken;
        }
    }
}

