/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class HasPrivilegesResponse
extends ActionResponse {
    private boolean completeMatch;
    private Map<String, Boolean> cluster;
    private List<IndexPrivileges> index;

    public HasPrivilegesResponse() {
        this(true, Collections.emptyMap(), Collections.emptyList());
    }

    public HasPrivilegesResponse(boolean completeMatch, Map<String, Boolean> cluster, Collection<IndexPrivileges> index) {
        this.completeMatch = completeMatch;
        this.cluster = new HashMap<String, Boolean>(cluster);
        this.index = new ArrayList<IndexPrivileges>(index);
    }

    public boolean isCompleteMatch() {
        return this.completeMatch;
    }

    public Map<String, Boolean> getClusterPrivileges() {
        return Collections.unmodifiableMap(this.cluster);
    }

    public List<IndexPrivileges> getIndexPrivileges() {
        return Collections.unmodifiableList(this.index);
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.completeMatch = in.readBoolean();
        int count = in.readVInt();
        this.index = new ArrayList<IndexPrivileges>(count);
        for (int i = 0; i < count; ++i) {
            String index = in.readString();
            Map privileges = in.readMap(StreamInput::readString, StreamInput::readBoolean);
            this.index.add(new IndexPrivileges(index, privileges));
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.completeMatch);
        out.writeVInt(this.index.size());
        for (IndexPrivileges index : this.index) {
            out.writeString(index.index);
            out.writeMap(index.privileges, StreamOutput::writeString, StreamOutput::writeBoolean);
        }
    }

    public static class IndexPrivileges {
        private final String index;
        private final Map<String, Boolean> privileges;

        public IndexPrivileges(String index, Map<String, Boolean> privileges) {
            this.index = Objects.requireNonNull(index);
            this.privileges = Collections.unmodifiableMap(privileges);
        }

        public String getIndex() {
            return this.index;
        }

        public Map<String, Boolean> getPrivileges() {
            return this.privileges;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{index='" + this.index + '\'' + ", privileges=" + this.privileges + '}';
        }

        public int hashCode() {
            int result = this.index.hashCode();
            result = 31 * result + this.privileges.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexPrivileges other = (IndexPrivileges)o;
            return this.index.equals(other.index) && this.privileges.equals(other.privileges);
        }
    }
}

