/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.tophits;

import com.carrotsearch.hppc.LongObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.LongObjectPagedHashMap;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.tophits.InternalTopHits;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.SubSearchContext;
import org.elasticsearch.search.rescore.RescoreContext;
import org.elasticsearch.search.sort.SortAndFormats;

public class TopHitsAggregator
extends MetricsAggregator {
    private final FetchPhase fetchPhase;
    private final SubSearchContext subSearchContext;
    private final LongObjectPagedHashMap<TopDocsCollector<?>> topDocsCollectors;

    TopHitsAggregator(FetchPhase fetchPhase, SubSearchContext subSearchContext, String name, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.fetchPhase = fetchPhase;
        this.topDocsCollectors = new LongObjectPagedHashMap(1L, context.bigArrays());
        this.subSearchContext = subSearchContext;
    }

    @Override
    public boolean needsScores() {
        SortAndFormats sort = this.subSearchContext.sort();
        if (sort != null) {
            return sort.sort.needsScores() || this.subSearchContext.trackScores();
        }
        return true;
    }

    @Override
    public LeafBucketCollector getLeafCollector(final LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        final LongObjectHashMap leafCollectors = new LongObjectHashMap(1);
        return new LeafBucketCollectorBase(sub, null){
            Scorer scorer;

            @Override
            public void setScorer(Scorer scorer) throws IOException {
                this.scorer = scorer;
                super.setScorer(scorer);
                for (ObjectCursor cursor : leafCollectors.values()) {
                    ((LeafCollector)cursor.value).setScorer(scorer);
                }
            }

            @Override
            public void collect(int docId, long bucket) throws IOException {
                LeafCollector leafCollector;
                int key;
                TopDocsCollector topDocsCollector = (TopDocsCollector)TopHitsAggregator.this.topDocsCollectors.get(bucket);
                if (topDocsCollector == null) {
                    SortAndFormats sort = TopHitsAggregator.this.subSearchContext.sort();
                    int topN = TopHitsAggregator.this.subSearchContext.from() + TopHitsAggregator.this.subSearchContext.size();
                    if (sort == null) {
                        for (RescoreContext rescoreContext : TopHitsAggregator.this.context.rescore()) {
                            topN = Math.max(rescoreContext.getWindowSize(), topN);
                        }
                    }
                    topN = Math.min(topN, TopHitsAggregator.this.subSearchContext.searcher().getIndexReader().maxDoc());
                    topDocsCollector = sort == null ? TopScoreDocCollector.create(topN) : TopFieldCollector.create(sort.sort, topN, true, TopHitsAggregator.this.subSearchContext.trackScores(), TopHitsAggregator.this.subSearchContext.trackScores(), true);
                    TopHitsAggregator.this.topDocsCollectors.put(bucket, topDocsCollector);
                }
                if ((key = leafCollectors.indexOf(bucket)) < 0) {
                    leafCollector = topDocsCollector.getLeafCollector(ctx);
                    if (this.scorer != null) {
                        leafCollector.setScorer(this.scorer);
                    }
                    leafCollectors.indexInsert(key, bucket, (Object)leafCollector);
                } else {
                    leafCollector = (LeafCollector)leafCollectors.indexGet(key);
                }
                leafCollector.collect(docId);
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        InternalTopHits topHits;
        TopDocsCollector<?> topDocsCollector = this.topDocsCollectors.get(owningBucketOrdinal);
        if (topDocsCollector == null) {
            topHits = this.buildEmptyAggregation();
        } else {
            TopDocs topDocs = topDocsCollector.topDocs();
            if (this.subSearchContext.sort() == null) {
                for (RescoreContext ctx : this.context().rescore()) {
                    try {
                        topDocs = ctx.rescorer().rescore(topDocs, this.context.searcher(), ctx);
                    }
                    catch (IOException e) {
                        throw new ElasticsearchException("Rescore TopHits Failed", (Throwable)e, new Object[0]);
                    }
                }
            }
            this.subSearchContext.queryResult().topDocs(topDocs, this.subSearchContext.sort() == null ? null : this.subSearchContext.sort().formats);
            int[] docIdsToLoad = new int[topDocs.scoreDocs.length];
            for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
                docIdsToLoad[i] = topDocs.scoreDocs[i].doc;
            }
            this.subSearchContext.docIdsToLoad(docIdsToLoad, 0, docIdsToLoad.length);
            this.fetchPhase.execute(this.subSearchContext);
            FetchSearchResult fetchResult = this.subSearchContext.fetchResult();
            SearchHit[] internalHits = fetchResult.fetchResult().hits().getHits();
            for (int i = 0; i < internalHits.length; ++i) {
                ScoreDoc scoreDoc = topDocs.scoreDocs[i];
                SearchHit searchHitFields = internalHits[i];
                searchHitFields.shard(this.subSearchContext.shardTarget());
                searchHitFields.score(scoreDoc.score);
                if (!(scoreDoc instanceof FieldDoc)) continue;
                FieldDoc fieldDoc = (FieldDoc)scoreDoc;
                searchHitFields.sortValues(fieldDoc.fields, this.subSearchContext.sort().formats);
            }
            topHits = new InternalTopHits(this.name, this.subSearchContext.from(), this.subSearchContext.size(), topDocs, fetchResult.hits(), this.pipelineAggregators(), this.metaData());
        }
        return topHits;
    }

    @Override
    public InternalTopHits buildEmptyAggregation() {
        TopDocs topDocs = this.subSearchContext.sort() != null ? new TopFieldDocs(0L, new FieldDoc[0], this.subSearchContext.sort().sort.getSort(), Float.NaN) : Lucene.EMPTY_TOP_DOCS;
        return new InternalTopHits(this.name, this.subSearchContext.from(), this.subSearchContext.size(), topDocs, SearchHits.empty(), this.pipelineAggregators(), this.metaData());
    }

    @Override
    protected void doClose() {
        Releasables.close(new Releasable[]{this.topDocsCollectors});
    }
}

