/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.ExpressionId;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.EsField;

public class Alias
extends NamedExpression {
    private final Expression child;
    private final String qualifier;
    private Attribute lazyAttribute;

    public Alias(Location location, String name, Expression child) {
        this(location, name, null, child, null);
    }

    public Alias(Location location, String name, String qualifier, Expression child) {
        this(location, name, qualifier, child, null);
    }

    public Alias(Location location, String name, String qualifier, Expression child, ExpressionId id) {
        this(location, name, qualifier, child, id, false);
    }

    public Alias(Location location, String name, String qualifier, Expression child, ExpressionId id, boolean synthetic) {
        super(location, name, Collections.singletonList(child), id, synthetic);
        this.child = child;
        this.qualifier = qualifier;
    }

    @Override
    protected NodeInfo<Alias> info() {
        return NodeInfo.create(this, Alias::new, this.name(), this.qualifier, this.child, this.id(), this.synthetic());
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 1) {
            throw new IllegalArgumentException("expected [1] child but received [" + newChildren.size() + "]");
        }
        return new Alias(this.location(), this.name(), this.qualifier, newChildren.get(0), this.id(), this.synthetic());
    }

    public Expression child() {
        return this.child;
    }

    public String qualifier() {
        return this.qualifier;
    }

    @Override
    public boolean nullable() {
        return this.child.nullable();
    }

    @Override
    public DataType dataType() {
        return this.child.dataType();
    }

    @Override
    public Attribute toAttribute() {
        if (this.lazyAttribute == null) {
            this.lazyAttribute = this.createAttribute();
        }
        return this.lazyAttribute;
    }

    private Attribute createAttribute() {
        if (this.resolved()) {
            Expression c = this.child();
            Attribute attr = Expressions.attribute(c);
            if (attr != null) {
                return attr.clone(this.location(), this.name(), this.qualifier, this.child.nullable(), this.id(), this.synthetic());
            }
            return new FieldAttribute(this.location(), null, this.name(), new EsField(this.name(), this.child.dataType(), Collections.emptyMap(), true), this.qualifier, this.child.nullable(), this.id(), this.synthetic());
        }
        return new UnresolvedAttribute(this.location(), this.name(), this.qualifier);
    }

    @Override
    public String toString() {
        return this.child + " AS " + this.name() + "#" + this.id();
    }
}

