/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class SqlSourceBuilder {
    final Set<String> sourceFields = new LinkedHashSet<String>();
    final Set<String> docFields = new LinkedHashSet<String>();
    final Map<String, Script> scriptFields = new LinkedHashMap<String, Script>();
    boolean trackScores = false;

    public void trackScores() {
        this.trackScores = true;
    }

    public void addSourceField(String field) {
        this.sourceFields.add(field);
    }

    public void addDocField(String field) {
        this.docFields.add(field);
    }

    public void addScriptField(String name, Script script) {
        this.scriptFields.put(name, script);
    }

    public void build(SearchSourceBuilder sourceBuilder) {
        sourceBuilder.trackScores(this.trackScores);
        if (!this.sourceFields.isEmpty()) {
            sourceBuilder.fetchSource(this.sourceFields.toArray(Strings.EMPTY_ARRAY), null);
        }
        this.docFields.forEach(arg_0 -> ((SearchSourceBuilder)sourceBuilder).docValueField(arg_0));
        this.scriptFields.forEach((arg_0, arg_1) -> ((SearchSourceBuilder)sourceBuilder).scriptField(arg_0, arg_1));
    }
}

