/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentValueValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class StringArgument
extends Argument {
    private static final long serialVersionUID = 1088032496970585118L;
    private final ArrayList<String> values;
    private final List<ArgumentValueValidator> validators;
    private final List<String> defaultValues;
    private volatile Pattern valueRegex;
    private final Set<String> allowedValues;
    private volatile String valueRegexExplanation;

    public StringArgument(Character shortIdentifier, String longIdentifier, String description) throws ArgumentException {
        this(shortIdentifier, longIdentifier, false, 1, null, description);
    }

    public StringArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, null, (List<String>)null);
    }

    public StringArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, Set<String> allowedValues) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, allowedValues, (List<String>)null);
    }

    public StringArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, String defaultValue) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, null, defaultValue == null ? null : Arrays.asList(defaultValue));
    }

    public StringArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, List<String> defaultValues) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, null, defaultValues);
    }

    public StringArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, Set<String> allowedValues, String defaultValue) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, allowedValues, defaultValue == null ? null : Arrays.asList(defaultValue));
    }

    public StringArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, Set<String> allowedValues, List<String> defaultValues) throws ArgumentException {
        super(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder == null ? ArgsMessages.INFO_PLACEHOLDER_VALUE.get() : valuePlaceholder, description);
        if (allowedValues == null || allowedValues.isEmpty()) {
            this.allowedValues = null;
        } else {
            HashSet<String> lowerValues = new HashSet<String>(allowedValues.size());
            for (String s : allowedValues) {
                lowerValues.add(StaticUtils.toLowerCase(s));
            }
            this.allowedValues = Collections.unmodifiableSet(lowerValues);
        }
        this.defaultValues = defaultValues == null || defaultValues.isEmpty() ? null : Collections.unmodifiableList(defaultValues);
        if (this.allowedValues != null && this.defaultValues != null) {
            for (String s : this.defaultValues) {
                String lowerDefault = StaticUtils.toLowerCase(s);
                if (this.allowedValues.contains(lowerDefault)) continue;
                throw new ArgumentException(ArgsMessages.ERR_ARG_DEFAULT_VALUE_NOT_ALLOWED.get(s, this.getIdentifierString()));
            }
        }
        this.values = new ArrayList(5);
        this.validators = new ArrayList<ArgumentValueValidator>(5);
        this.valueRegex = null;
        this.valueRegexExplanation = null;
    }

    private StringArgument(StringArgument source) {
        super(source);
        this.allowedValues = source.allowedValues;
        this.defaultValues = source.defaultValues;
        this.valueRegex = source.valueRegex;
        this.valueRegexExplanation = source.valueRegexExplanation;
        this.values = new ArrayList(5);
        this.validators = new ArrayList<ArgumentValueValidator>(source.validators);
    }

    public Set<String> getAllowedValues() {
        return this.allowedValues;
    }

    public List<String> getDefaultValues() {
        return this.defaultValues;
    }

    public Pattern getValueRegex() {
        return this.valueRegex;
    }

    public String getValueRegexExplanation() {
        return this.valueRegexExplanation;
    }

    public void setValueRegex(Pattern valueRegex, String explanation) {
        this.valueRegex = valueRegex;
        this.valueRegexExplanation = explanation;
    }

    public void addValueValidator(ArgumentValueValidator validator) {
        this.validators.add(validator);
    }

    @Override
    protected void addValue(String valueString) throws ArgumentException {
        Matcher matcher;
        String lowerValue = StaticUtils.toLowerCase(valueString);
        if (this.allowedValues != null && !this.allowedValues.contains(lowerValue)) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_VALUE_NOT_ALLOWED.get(valueString, this.getIdentifierString()));
        }
        if (this.values.size() >= this.getMaxOccurrences()) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MAX_OCCURRENCES_EXCEEDED.get(this.getIdentifierString()));
        }
        if (this.valueRegex != null && !(matcher = this.valueRegex.matcher(valueString)).matches()) {
            String pattern = this.valueRegex.pattern();
            if (this.valueRegexExplanation == null) {
                throw new ArgumentException(ArgsMessages.ERR_ARG_VALUE_DOES_NOT_MATCH_PATTERN_WITHOUT_EXPLANATION.get(valueString, this.getIdentifierString(), pattern));
            }
            throw new ArgumentException(ArgsMessages.ERR_ARG_VALUE_DOES_NOT_MATCH_PATTERN_WITH_EXPLANATION.get(valueString, this.getIdentifierString(), pattern, this.valueRegexExplanation));
        }
        for (ArgumentValueValidator v : this.validators) {
            v.validateArgumentValue(this, valueString);
        }
        this.values.add(valueString);
    }

    public String getValue() {
        if (this.values.isEmpty()) {
            if (this.defaultValues == null || this.defaultValues.isEmpty()) {
                return null;
            }
            return this.defaultValues.get(0);
        }
        return this.values.get(0);
    }

    public List<String> getValues() {
        if (this.values.isEmpty() && this.defaultValues != null) {
            return this.defaultValues;
        }
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public List<String> getValueStringRepresentations(boolean useDefault) {
        if (!this.values.isEmpty()) {
            return Collections.unmodifiableList(this.values);
        }
        if (useDefault && this.defaultValues != null) {
            return Collections.unmodifiableList(this.defaultValues);
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean hasDefaultValue() {
        return this.defaultValues != null && !this.defaultValues.isEmpty();
    }

    @Override
    public String getDataTypeName() {
        return ArgsMessages.INFO_STRING_TYPE_NAME.get();
    }

    @Override
    public String getValueConstraints() {
        StringBuilder buffer = null;
        if (this.valueRegex != null) {
            buffer = new StringBuilder();
            String pattern = this.valueRegex.pattern();
            if (this.valueRegexExplanation == null || this.valueRegexExplanation.length() == 0) {
                buffer.append(ArgsMessages.INFO_STRING_CONSTRAINTS_REGEX_WITHOUT_EXPLANATION.get(pattern));
            } else {
                buffer.append(ArgsMessages.INFO_STRING_CONSTRAINTS_REGEX_WITHOUT_EXPLANATION.get(pattern, this.valueRegexExplanation));
            }
        }
        if (this.allowedValues != null && !this.allowedValues.isEmpty()) {
            if (buffer == null) {
                buffer = new StringBuilder();
            } else {
                buffer.append("  ");
            }
            buffer.append(ArgsMessages.INFO_STRING_CONSTRAINTS_ALLOWED_VALUE.get());
            buffer.append("  ");
            Iterator<String> iterator = this.allowedValues.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('.');
        }
        if (buffer == null) {
            return null;
        }
        return buffer.toString();
    }

    @Override
    protected void reset() {
        super.reset();
        this.values.clear();
    }

    @Override
    public StringArgument getCleanCopy() {
        return new StringArgument(this);
    }

    @Override
    protected void addToCommandLine(List<String> argStrings) {
        if (this.values != null) {
            for (String s : this.values) {
                argStrings.add(this.getIdentifierString());
                if (this.isSensitive()) {
                    argStrings.add("***REDACTED***");
                    continue;
                }
                argStrings.add(s);
            }
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        Iterator<String> iterator;
        buffer.append("StringArgument(");
        this.appendBasicToStringInfo(buffer);
        if (this.allowedValues != null && !this.allowedValues.isEmpty()) {
            buffer.append(", allowedValues={");
            iterator = this.allowedValues.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('}');
        }
        if (this.valueRegex != null) {
            buffer.append(", valueRegex='");
            buffer.append(this.valueRegex.pattern());
            buffer.append('\'');
            if (this.valueRegexExplanation != null) {
                buffer.append(", valueRegexExplanation='");
                buffer.append(this.valueRegexExplanation);
                buffer.append('\'');
            }
        }
        if (this.defaultValues != null && !this.defaultValues.isEmpty()) {
            if (this.defaultValues.size() == 1) {
                buffer.append(", defaultValue='");
                buffer.append(this.defaultValues.get(0));
            } else {
                buffer.append(", defaultValues={");
                iterator = this.defaultValues.iterator();
                while (iterator.hasNext()) {
                    buffer.append('\'');
                    buffer.append(iterator.next());
                    buffer.append('\'');
                    if (!iterator.hasNext()) continue;
                    buffer.append(", ");
                }
                buffer.append('}');
            }
        }
        buffer.append(')');
    }
}

