/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.util.Debug;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class FastestConnectThread
extends Thread {
    private final AtomicBoolean connectionSelected;
    private final BlockingQueue<Object> resultQueue;
    private final int port;
    private final LDAPConnection connection;
    private final LDAPConnectionPoolHealthCheck healthCheck;
    private final String address;

    FastestConnectThread(String address, int port, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions, LDAPConnectionPoolHealthCheck healthCheck, BlockingQueue<Object> resultQueue, AtomicBoolean connectionSelected) {
        super("Fastest Connect Thread for " + address + ':' + port);
        this.setDaemon(true);
        this.address = address;
        this.port = port;
        this.healthCheck = healthCheck;
        this.resultQueue = resultQueue;
        this.connectionSelected = connectionSelected;
        this.connection = new LDAPConnection(socketFactory, connectionOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean returned = false;
        try {
            try {
                this.connection.connect(this.address, this.port);
                if (this.healthCheck != null) {
                    this.healthCheck.ensureNewConnectionValid(this.connection);
                }
                returned = this.connectionSelected.compareAndSet(false, true) && this.resultQueue.offer(this.connection);
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.resultQueue.offer(e);
                Object var4_3 = null;
                if (!returned) {
                    this.connection.close();
                }
            }
            Object var4_2 = null;
            if (!returned) {
                this.connection.close();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!returned) {
                this.connection.close();
            }
            throw throwable;
        }
    }
}

