/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.IsolateDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportStartDatafeedAction;

public class TransportIsolateDatafeedAction
extends TransportTasksAction<TransportStartDatafeedAction.DatafeedTask, IsolateDatafeedAction.Request, IsolateDatafeedAction.Response, IsolateDatafeedAction.Response> {
    @Inject
    public TransportIsolateDatafeedAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService) {
        super(settings, "cluster:internal/xpack/ml/datafeed/isolate", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, IsolateDatafeedAction.Request::new, IsolateDatafeedAction.Response::new, "ml_utility");
    }

    protected void doExecute(Task task, IsolateDatafeedAction.Request request, ActionListener<IsolateDatafeedAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
        PersistentTasksCustomMetaData.PersistentTask datafeedTask = MlMetadata.getDatafeedTask((String)request.getDatafeedId(), (PersistentTasksCustomMetaData)tasks);
        if (datafeedTask == null || datafeedTask.getExecutorNode() == null) {
            listener.onResponse((Object)new IsolateDatafeedAction.Response());
            return;
        }
        String executorNode = datafeedTask.getExecutorNode();
        DiscoveryNodes nodes = state.nodes();
        if (nodes.resolveNode(executorNode).getVersion().before(Version.V_5_5_0)) {
            listener.onFailure((Exception)new ElasticsearchException("Force delete datafeed is not supported because the datafeed task is running on a node [" + executorNode + "] with a version prior to " + Version.V_5_5_0, new Object[0]));
            return;
        }
        request.setNodes(new String[]{datafeedTask.getExecutorNode()});
        super.doExecute(task, (BaseTasksRequest)request, listener);
    }

    protected IsolateDatafeedAction.Response newResponse(IsolateDatafeedAction.Request request, List<IsolateDatafeedAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (!taskOperationFailures.isEmpty()) {
            throw ExceptionsHelper.convertToElastic((Exception)taskOperationFailures.get(0).getCause());
        }
        if (!failedNodeExceptions.isEmpty()) {
            throw ExceptionsHelper.convertToElastic((Exception)((Exception)failedNodeExceptions.get(0)));
        }
        return new IsolateDatafeedAction.Response();
    }

    protected void taskOperation(IsolateDatafeedAction.Request request, TransportStartDatafeedAction.DatafeedTask datafeedTask, ActionListener<IsolateDatafeedAction.Response> listener) {
        datafeedTask.isolate();
        listener.onResponse((Object)new IsolateDatafeedAction.Response());
    }

    protected IsolateDatafeedAction.Response readTaskResponse(StreamInput in) throws IOException {
        return new IsolateDatafeedAction.Response(in);
    }
}

