/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.role;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public class GetRolesResponse
extends ActionResponse {
    private RoleDescriptor[] roles;

    public GetRolesResponse(RoleDescriptor ... roles) {
        this.roles = roles;
    }

    public RoleDescriptor[] roles() {
        return this.roles;
    }

    public boolean hasRoles() {
        return this.roles.length > 0;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.roles = new RoleDescriptor[size];
        for (int i = 0; i < size; ++i) {
            this.roles[i] = RoleDescriptor.readFrom(in);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.roles.length);
        for (RoleDescriptor role : this.roles) {
            RoleDescriptor.writeTo(role, out);
        }
    }
}

