/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.rest.RestStatus;

public class LicenseUtils {
    public static final String EXPIRED_FEATURE_METADATA = "es.license.expired.feature";

    public static ElasticsearchSecurityException newComplianceException(String feature) {
        ElasticsearchSecurityException e = new ElasticsearchSecurityException("current license is non-compliant for [{}]", RestStatus.FORBIDDEN, new Object[]{feature});
        e.addMetadata(EXPIRED_FEATURE_METADATA, new String[]{feature});
        return e;
    }

    public static boolean isLicenseExpiredException(ElasticsearchSecurityException exception) {
        return exception != null && exception.getMetadata(EXPIRED_FEATURE_METADATA) != null;
    }

    public static boolean licenseNeedsExtended(License license) {
        return "basic".equals(license.type()) && license.expiryDate() != LicenseService.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS;
    }
}

