/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.crypto.XMLSigningUtil;

class SigningConfiguration {
    private final Set<String> messageTypes;
    private final X509Credential credential;

    SigningConfiguration(Set<String> messageTypes, X509Credential credential) {
        this.messageTypes = messageTypes;
        this.credential = credential;
    }

    boolean shouldSign(SAMLObject object) {
        return this.shouldSign(object.getElementQName().getLocalPart());
    }

    boolean shouldSign(String elementName) {
        if (this.credential == null) {
            return false;
        }
        return this.messageTypes.contains(elementName) || this.messageTypes.contains("*");
    }

    byte[] sign(String text, String algo) throws SecurityException {
        return this.sign(text.getBytes(StandardCharsets.UTF_8), algo);
    }

    byte[] sign(byte[] content, String algo) throws SecurityException {
        return XMLSigningUtil.signWithURI((Credential)this.credential, (String)algo, (byte[])content);
    }

    X509Credential getCredential() {
        return this.credential;
    }
}

