/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import com.carrotsearch.hppc.ObjectLongHashMap;
import java.io.IOException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.suggest.document.CompletionTerms;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.FieldMemoryStats;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.search.suggest.completion.CompletionStats;

public class CompletionFieldStats {
    public static CompletionStats completionStats(IndexReader indexReader, String ... fieldNamePatterns) {
        long sizeInBytes = 0L;
        ObjectLongHashMap completionFields = null;
        if (fieldNamePatterns != null && fieldNamePatterns.length > 0) {
            completionFields = new ObjectLongHashMap(fieldNamePatterns.length);
        }
        for (LeafReaderContext atomicReaderContext : indexReader.leaves()) {
            LeafReader atomicReader = atomicReaderContext.reader();
            try {
                for (FieldInfo info : atomicReader.getFieldInfos()) {
                    Terms terms = atomicReader.terms(info.name);
                    if (!(terms instanceof CompletionTerms)) continue;
                    long fstSize = ((CompletionTerms)terms).suggester().ramBytesUsed();
                    if (fieldNamePatterns != null && fieldNamePatterns.length > 0 && Regex.simpleMatch(fieldNamePatterns, info.name)) {
                        completionFields.addTo((Object)info.name, fstSize);
                    }
                    sizeInBytes += fstSize;
                }
            }
            catch (IOException ioe) {
                throw new ElasticsearchException(ioe);
            }
        }
        return new CompletionStats(sizeInBytes, completionFields == null ? null : new FieldMemoryStats((ObjectLongHashMap<String>)completionFields));
    }
}

