/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class VirtualListViewRequestControl
extends Control {
    public static final String VIRTUAL_LIST_VIEW_REQUEST_OID = "2.16.840.1.113730.3.4.9";
    private static final byte TARGET_TYPE_OFFSET = -96;
    private static final byte TARGET_TYPE_GREATER_OR_EQUAL = -127;
    private static final long serialVersionUID = 4348423177859960815L;
    private final ASN1OctetString assertionValue;
    private final ASN1OctetString contextID;
    private final int afterCount;
    private final int beforeCount;
    private final int contentCount;
    private final int targetOffset;

    public VirtualListViewRequestControl(int targetOffset, int beforeCount, int afterCount, int contentCount, ASN1OctetString contextID) {
        this(targetOffset, beforeCount, afterCount, contentCount, contextID, true);
    }

    public VirtualListViewRequestControl(String assertionValue, int beforeCount, int afterCount, ASN1OctetString contextID) {
        this(new ASN1OctetString(assertionValue), beforeCount, afterCount, contextID, true);
    }

    public VirtualListViewRequestControl(byte[] assertionValue, int beforeCount, int afterCount, ASN1OctetString contextID) {
        this(new ASN1OctetString(assertionValue), beforeCount, afterCount, contextID, true);
    }

    public VirtualListViewRequestControl(ASN1OctetString assertionValue, int beforeCount, int afterCount, ASN1OctetString contextID) {
        this(assertionValue, beforeCount, afterCount, contextID, true);
    }

    public VirtualListViewRequestControl(int targetOffset, int beforeCount, int afterCount, int contentCount, ASN1OctetString contextID, boolean isCritical) {
        super(VIRTUAL_LIST_VIEW_REQUEST_OID, isCritical, VirtualListViewRequestControl.encodeValue(targetOffset, beforeCount, afterCount, contentCount, contextID));
        this.targetOffset = targetOffset;
        this.beforeCount = beforeCount;
        this.afterCount = afterCount;
        this.contentCount = contentCount;
        this.contextID = contextID;
        this.assertionValue = null;
    }

    public VirtualListViewRequestControl(String assertionValue, int beforeCount, int afterCount, ASN1OctetString contextID, boolean isCritical) {
        this(new ASN1OctetString(assertionValue), beforeCount, afterCount, contextID, isCritical);
    }

    public VirtualListViewRequestControl(byte[] assertionValue, int beforeCount, int afterCount, ASN1OctetString contextID, boolean isCritical) {
        this(new ASN1OctetString(assertionValue), beforeCount, afterCount, contextID, isCritical);
    }

    public VirtualListViewRequestControl(ASN1OctetString assertionValue, int beforeCount, int afterCount, ASN1OctetString contextID, boolean isCritical) {
        super(VIRTUAL_LIST_VIEW_REQUEST_OID, isCritical, VirtualListViewRequestControl.encodeValue(assertionValue, beforeCount, afterCount, contextID));
        this.assertionValue = assertionValue;
        this.beforeCount = beforeCount;
        this.afterCount = afterCount;
        this.contextID = contextID;
        this.targetOffset = -1;
        this.contentCount = -1;
    }

    public VirtualListViewRequestControl(Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(valueElement).elements();
            this.beforeCount = ASN1Integer.decodeAsInteger(elements[0]).intValue();
            this.afterCount = ASN1Integer.decodeAsInteger(elements[1]).intValue();
            switch (elements[2].getType()) {
                case -96: {
                    this.assertionValue = null;
                    ASN1Element[] offsetElements = ASN1Sequence.decodeAsSequence(elements[2]).elements();
                    this.targetOffset = ASN1Integer.decodeAsInteger(offsetElements[0]).intValue();
                    this.contentCount = ASN1Integer.decodeAsInteger(offsetElements[1]).intValue();
                    break;
                }
                case -127: {
                    this.assertionValue = ASN1OctetString.decodeAsOctetString(elements[2]);
                    this.targetOffset = -1;
                    this.contentCount = -1;
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_REQUEST_INVALID_ELEMENT_TYPE.get(StaticUtils.toHex(elements[2].getType())));
                }
            }
            this.contextID = elements.length == 4 ? ASN1OctetString.decodeAsOctetString(elements[3]) : null;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_REQUEST_CANNOT_DECODE.get(e), e);
        }
    }

    private static ASN1OctetString encodeValue(int targetOffset, int beforeCount, int afterCount, int contentCount, ASN1OctetString contextID) {
        ASN1Element[] targetElements = new ASN1Element[]{new ASN1Integer(targetOffset), new ASN1Integer(contentCount)};
        ASN1Element[] vlvElements = contextID == null ? new ASN1Element[]{new ASN1Integer(beforeCount), new ASN1Integer(afterCount), new ASN1Sequence(-96, targetElements)} : new ASN1Element[]{new ASN1Integer(beforeCount), new ASN1Integer(afterCount), new ASN1Sequence(-96, targetElements), contextID};
        return new ASN1OctetString(new ASN1Sequence(vlvElements).encode());
    }

    private static ASN1OctetString encodeValue(ASN1OctetString assertionValue, int beforeCount, int afterCount, ASN1OctetString contextID) {
        Validator.ensureNotNull(assertionValue);
        ASN1Element[] vlvElements = contextID == null ? new ASN1Element[]{new ASN1Integer(beforeCount), new ASN1Integer(afterCount), new ASN1OctetString(-127, assertionValue.getValue())} : new ASN1Element[]{new ASN1Integer(beforeCount), new ASN1Integer(afterCount), new ASN1OctetString(-127, assertionValue.getValue()), contextID};
        return new ASN1OctetString(new ASN1Sequence(vlvElements).encode());
    }

    public int getTargetOffset() {
        return this.targetOffset;
    }

    public String getAssertionValueString() {
        if (this.assertionValue == null) {
            return null;
        }
        return this.assertionValue.stringValue();
    }

    public byte[] getAssertionValueBytes() {
        if (this.assertionValue == null) {
            return null;
        }
        return this.assertionValue.getValue();
    }

    public ASN1OctetString getAssertionValue() {
        return this.assertionValue;
    }

    public int getBeforeCount() {
        return this.beforeCount;
    }

    public int getAfterCount() {
        return this.afterCount;
    }

    public int getContentCount() {
        return this.contentCount;
    }

    public ASN1OctetString getContextID() {
        return this.contextID;
    }

    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_VLV_REQUEST.get();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("VirtualListViewRequestControl(beforeCount=");
        buffer.append(this.beforeCount);
        buffer.append(", afterCount=");
        buffer.append(this.afterCount);
        if (this.assertionValue == null) {
            buffer.append(", targetOffset=");
            buffer.append(this.targetOffset);
            buffer.append(", contentCount=");
            buffer.append(this.contentCount);
        } else {
            buffer.append(", assertionValue='");
            buffer.append(this.assertionValue.stringValue());
            buffer.append('\'');
        }
        buffer.append(", isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

