/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.upgrade;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.IndexTemplateMissingException;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.template.TemplateUtils;
import org.elasticsearch.xpack.core.upgrade.UpgradeActionRequired;
import org.elasticsearch.xpack.core.upgrade.actions.IndexUpgradeAction;
import org.elasticsearch.xpack.core.upgrade.actions.IndexUpgradeInfoAction;
import org.elasticsearch.xpack.core.watcher.WatcherState;
import org.elasticsearch.xpack.core.watcher.client.WatcherClient;
import org.elasticsearch.xpack.core.watcher.transport.actions.service.WatcherServiceRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsResponse;
import org.elasticsearch.xpack.upgrade.IndexUpgradeCheck;
import org.elasticsearch.xpack.upgrade.IndexUpgradeService;
import org.elasticsearch.xpack.upgrade.actions.TransportIndexUpgradeAction;
import org.elasticsearch.xpack.upgrade.actions.TransportIndexUpgradeInfoAction;
import org.elasticsearch.xpack.upgrade.rest.RestIndexUpgradeAction;
import org.elasticsearch.xpack.upgrade.rest.RestIndexUpgradeInfoAction;

public class Upgrade
extends Plugin
implements ActionPlugin {
    public static final Version UPGRADE_INTRODUCED = Version.V_5_6_0;
    private static final int EXPECTED_INDEX_FORMAT_VERSION = 6;
    private final Settings settings;
    private final List<BiFunction<Client, ClusterService, IndexUpgradeCheck>> upgradeCheckFactories;

    public Upgrade(Settings settings) {
        this.settings = settings;
        this.upgradeCheckFactories = new ArrayList<BiFunction<Client, ClusterService, IndexUpgradeCheck>>();
        this.upgradeCheckFactories.add(Upgrade.getWatchesIndexUpgradeCheckFactory(settings));
        this.upgradeCheckFactories.add(Upgrade.getTriggeredWatchesIndexUpgradeCheckFactory(settings));
        this.upgradeCheckFactories.add(Upgrade.getSecurityUpgradeCheckFactory(settings));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        ArrayList<IndexUpgradeCheck> upgradeChecks = new ArrayList<IndexUpgradeCheck>(this.upgradeCheckFactories.size());
        for (BiFunction<Client, ClusterService, IndexUpgradeCheck> checkFactory : this.upgradeCheckFactories) {
            upgradeChecks.add(checkFactory.apply(client, clusterService));
        }
        return Collections.singletonList(new IndexUpgradeService(this.settings, Collections.unmodifiableList(upgradeChecks)));
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((GenericAction)IndexUpgradeInfoAction.INSTANCE, TransportIndexUpgradeInfoAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)IndexUpgradeAction.INSTANCE, TransportIndexUpgradeAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestHandler[]{new RestIndexUpgradeInfoAction(settings, restController), new RestIndexUpgradeAction(settings, restController)});
    }

    public static boolean checkInternalIndexFormat(IndexMetaData indexMetaData) {
        return indexMetaData.getSettings().getAsInt(IndexMetaData.INDEX_FORMAT_SETTING.getKey(), Integer.valueOf(0)) == 6;
    }

    static BiFunction<Client, ClusterService, IndexUpgradeCheck> getSecurityUpgradeCheckFactory(Settings settings) {
        return (client, clusterService) -> {
            Client clientWithOrigin = ClientHelper.clientWithOrigin((Client)client, (String)"security");
            return new IndexUpgradeCheck<Void>("security", settings, indexMetaData -> {
                if (".security".equals(indexMetaData.getIndex().getName()) || indexMetaData.getAliases().containsKey((Object)".security")) {
                    if (Upgrade.checkInternalIndexFormat(indexMetaData)) {
                        return UpgradeActionRequired.UP_TO_DATE;
                    }
                    return UpgradeActionRequired.UPGRADE;
                }
                return UpgradeActionRequired.NOT_APPLICABLE;
            }, clientWithOrigin, (ClusterService)clusterService, new String[]{"user", "reserved-user", "role", "doc"}, new Script(ScriptType.INLINE, "painless", "ctx._source.type = ctx._type;\nif (!ctx._type.equals(\"doc\")) {\n   ctx._id = ctx._type + \"-\" + ctx._id;\n   ctx._type = \"doc\";}\n", new HashMap()), listener -> listener.onResponse(null), (success, listener) -> Upgrade.postSecurityUpgrade(clientWithOrigin, (ActionListener<TransportResponse.Empty>)listener));
        };
    }

    private static void postSecurityUpgrade(Client client, final ActionListener<TransportResponse.Empty> listener) {
        client.prepareSearch(new String[]{".security"}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)User.Fields.TYPE.getPreferredName(), (String)"reserved-user")).setFetchSource(true).execute(ActionListener.wrap(searchResponse -> {
            assert (searchResponse.getHits().getTotalHits() <= 10L) : "there are more than 10 reserved users we need to change this to retrieve them all!";
            HashSet<String> toConvert = new HashSet<String>();
            for (SearchHit searchHit : searchResponse.getHits()) {
                Map sourceMap = searchHit.getSourceAsMap();
                if (!Upgrade.hasOldStyleDefaultPassword(sourceMap)) continue;
                toConvert.add(searchHit.getId());
            }
            if (toConvert.isEmpty()) {
                listener.onResponse((Object)TransportResponse.Empty.INSTANCE);
            } else {
                BulkRequestBuilder bulkRequestBuilder = client.prepareBulk();
                for (String id : toConvert) {
                    UpdateRequest updateRequest = new UpdateRequest(".security", "doc", "reserved-user-" + id);
                    updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).doc(new Object[]{User.Fields.PASSWORD.getPreferredName(), "", User.Fields.TYPE.getPreferredName(), "reserved-user"});
                    bulkRequestBuilder.add(updateRequest);
                }
                bulkRequestBuilder.execute((ActionListener)new ActionListener<BulkResponse>(){

                    public void onResponse(BulkResponse bulkItemResponses) {
                        if (bulkItemResponses.hasFailures()) {
                            String msg = "failed to update old style reserved user passwords: " + bulkItemResponses.buildFailureMessage();
                            listener.onFailure((Exception)new ElasticsearchException(msg, new Object[0]));
                        } else {
                            listener.onResponse((Object)TransportResponse.Empty.INSTANCE);
                        }
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private static boolean hasOldStyleDefaultPassword(Map<String, Object> userSource) {
        String passwordHash = (String)userSource.get(User.Fields.PASSWORD.getPreferredName());
        if (passwordHash == null) {
            throw new IllegalStateException("passwordHash should never be null");
        }
        if (passwordHash.isEmpty()) {
            return false;
        }
        try (SecureString secureString = new SecureString(passwordHash.toCharArray());){
            boolean bl = Hasher.BCRYPT.verify(new SecureString("".toCharArray()), secureString.getChars());
            return bl;
        }
    }

    static BiFunction<Client, ClusterService, IndexUpgradeCheck> getWatchesIndexUpgradeCheckFactory(Settings settings) {
        return (client, clusterService) -> {
            Client clientWithOrigin = ClientHelper.clientWithOrigin((Client)client, (String)"watcher");
            return new IndexUpgradeCheck<Boolean>("watches", settings, indexMetaData -> {
                if (Upgrade.indexOrAliasExists(indexMetaData, ".watches")) {
                    if (Upgrade.checkInternalIndexFormat(indexMetaData)) {
                        return UpgradeActionRequired.UP_TO_DATE;
                    }
                    return UpgradeActionRequired.UPGRADE;
                }
                return UpgradeActionRequired.NOT_APPLICABLE;
            }, clientWithOrigin, (ClusterService)clusterService, new String[]{"watch"}, new Script(ScriptType.INLINE, "painless", "ctx._type = \"doc\";\nif (ctx._source.containsKey(\"_status\") && !ctx._source.containsKey(\"status\")  ) {\n  ctx._source.status = ctx._source.remove(\"_status\");\n}", new HashMap()), booleanActionListener -> Upgrade.preWatchesIndexUpgrade(clientWithOrigin, (ActionListener<Boolean>)booleanActionListener), (shouldStartWatcher, listener) -> Upgrade.postWatchesIndexUpgrade(clientWithOrigin, shouldStartWatcher, (ActionListener<TransportResponse.Empty>)listener));
        };
    }

    static BiFunction<Client, ClusterService, IndexUpgradeCheck> getTriggeredWatchesIndexUpgradeCheckFactory(Settings settings) {
        return (client, clusterService) -> {
            Client clientWithOrigin = ClientHelper.clientWithOrigin((Client)client, (String)"watcher");
            return new IndexUpgradeCheck<Boolean>("triggered-watches", settings, indexMetaData -> {
                if (Upgrade.indexOrAliasExists(indexMetaData, ".triggered_watches")) {
                    if (Upgrade.checkInternalIndexFormat(indexMetaData)) {
                        return UpgradeActionRequired.UP_TO_DATE;
                    }
                    return UpgradeActionRequired.UPGRADE;
                }
                return UpgradeActionRequired.NOT_APPLICABLE;
            }, clientWithOrigin, (ClusterService)clusterService, new String[]{"triggered-watch"}, new Script(ScriptType.INLINE, "painless", "ctx._type = \"doc\";\n", new HashMap()), booleanActionListener -> Upgrade.preTriggeredWatchesIndexUpgrade(clientWithOrigin, (ActionListener<Boolean>)booleanActionListener), (shouldStartWatcher, listener) -> Upgrade.postWatchesIndexUpgrade(clientWithOrigin, shouldStartWatcher, (ActionListener<TransportResponse.Empty>)listener));
        };
    }

    private static boolean indexOrAliasExists(IndexMetaData indexMetaData, String name) {
        return name.equals(indexMetaData.getIndex().getName()) || indexMetaData.getAliases().containsKey((Object)name);
    }

    static void preTriggeredWatchesIndexUpgrade(Client client, ActionListener<Boolean> listener) {
        new WatcherClient(client).prepareWatcherStats().execute(ActionListener.wrap(stats -> {
            if (stats.watcherMetaData().manuallyStopped()) {
                Upgrade.preTriggeredWatchesIndexUpgrade(client, listener, false);
            } else {
                new WatcherClient(client).prepareWatchService().stop().execute(ActionListener.wrap(watcherServiceResponse -> {
                    if (watcherServiceResponse.isAcknowledged()) {
                        Upgrade.preTriggeredWatchesIndexUpgrade(client, listener, true);
                    } else {
                        listener.onFailure((Exception)new IllegalStateException("unable to stop watcher service"));
                    }
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private static void preTriggeredWatchesIndexUpgrade(Client client, ActionListener<Boolean> listener, boolean restart) {
        String legacyTriggeredWatchesTemplateName = "triggered_watches";
        ActionListener<DeleteIndexTemplateResponse> returnToCallerListener = Upgrade.deleteIndexTemplateListener("triggered_watches", listener, () -> listener.onResponse((Object)restart));
        ActionListener<PutIndexTemplateResponse> putTriggeredWatchesListener = Upgrade.putIndexTemplateListener(".triggered_watches", listener, () -> client.admin().indices().prepareDeleteTemplate("triggered_watches").execute(returnToCallerListener));
        byte[] triggeredWatchesTemplate = TemplateUtils.loadTemplate((String)"/triggered-watches.json", (String)"7", (String)Pattern.quote("${xpack.watcher.template.version}")).getBytes(StandardCharsets.UTF_8);
        client.admin().indices().preparePutTemplate(".triggered_watches").setSource(triggeredWatchesTemplate, XContentType.JSON).execute(putTriggeredWatchesListener);
    }

    static void preWatchesIndexUpgrade(Client client, ActionListener<Boolean> listener) {
        new WatcherClient(client).prepareWatcherStats().execute(ActionListener.wrap(stats -> {
            if (stats.watcherMetaData().manuallyStopped()) {
                Upgrade.preWatchesIndexUpgrade(client, listener, false);
            } else {
                new WatcherClient(client).prepareWatchService().stop().execute(ActionListener.wrap(watcherServiceResponse -> {
                    if (watcherServiceResponse.isAcknowledged()) {
                        Upgrade.preWatchesIndexUpgrade(client, listener, true);
                    } else {
                        listener.onFailure((Exception)new IllegalStateException("unable to stop watcher service"));
                    }
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private static void preWatchesIndexUpgrade(Client client, ActionListener<Boolean> listener, boolean restart) {
        String legacyWatchesTemplateName = "watches";
        ActionListener<DeleteIndexTemplateResponse> returnToCallerListener = Upgrade.deleteIndexTemplateListener("watches", listener, () -> listener.onResponse((Object)restart));
        ActionListener<PutIndexTemplateResponse> putTriggeredWatchesListener = Upgrade.putIndexTemplateListener(".triggered_watches", listener, () -> client.admin().indices().prepareDeleteTemplate("watches").execute(returnToCallerListener));
        byte[] watchesTemplate = TemplateUtils.loadTemplate((String)"/watches.json", (String)"7", (String)Pattern.quote("${xpack.watcher.template.version}")).getBytes(StandardCharsets.UTF_8);
        ActionListener<DeleteIndexTemplateResponse> deleteWatchHistoryTemplatesListener = Upgrade.deleteIndexTemplateListener("watch_history_*", listener, () -> client.admin().indices().preparePutTemplate(".watches").setSource(watchesTemplate, XContentType.JSON).execute(putTriggeredWatchesListener));
        client.admin().indices().prepareDeleteTemplate("watch_history_*").execute(deleteWatchHistoryTemplatesListener);
    }

    static void postWatchesIndexUpgrade(Client client, Boolean shouldStartWatcher, ActionListener<TransportResponse.Empty> listener) {
        if (shouldStartWatcher.booleanValue()) {
            WatcherClient watcherClient = new WatcherClient(client);
            watcherClient.prepareWatcherStats().execute(Upgrade.waitingStatsListener(0, listener, watcherClient));
        } else {
            listener.onResponse((Object)TransportResponse.Empty.INSTANCE);
        }
    }

    private static ActionListener<WatcherStatsResponse> waitingStatsListener(int currentCount, ActionListener<TransportResponse.Empty> listener, WatcherClient watcherClient) {
        return ActionListener.wrap(r -> {
            boolean watcherStoppedOnAllNodes = r.getNodes().stream().map(WatcherStatsResponse.Node::getWatcherState).allMatch(s -> s == WatcherState.STOPPED);
            if (!watcherStoppedOnAllNodes) {
                if (currentCount >= 10) {
                    listener.onFailure((Exception)new ElasticsearchException("watcher did not stop properly, so cannot start up again", new Object[0]));
                } else {
                    Thread.sleep(currentCount * 150);
                    watcherClient.prepareWatcherStats().execute(Upgrade.waitingStatsListener(currentCount + 1, listener, watcherClient));
                }
            } else {
                watcherClient.watcherService(new WatcherServiceRequest().start(), ActionListener.wrap(serviceResponse -> listener.onResponse((Object)TransportResponse.Empty.INSTANCE), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private static ActionListener<PutIndexTemplateResponse> putIndexTemplateListener(String name, ActionListener<Boolean> listener, Runnable runnable) {
        return ActionListener.wrap(r -> {
            if (r.isAcknowledged()) {
                runnable.run();
            } else {
                listener.onFailure((Exception)new ElasticsearchException("Putting [{}] template was not acknowledged", new Object[]{name}));
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private static ActionListener<DeleteIndexTemplateResponse> deleteIndexTemplateListener(String name, ActionListener<Boolean> listener, Runnable runnable) {
        return ActionListener.wrap(r -> {
            if (r.isAcknowledged()) {
                runnable.run();
            } else {
                listener.onFailure((Exception)new ElasticsearchException("Deleting [{}] template was not acknowledged", new Object[]{name}));
            }
        }, e -> {
            if (e instanceof IndexTemplateMissingException) {
                runnable.run();
            } else {
                listener.onFailure(e);
            }
        });
    }
}

