/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.query.QueryShardContext;

public final class QueryParserHelper {
    private static final Set<String> ALLOWED_QUERY_MAPPER_TYPES = new HashSet<String>();

    private QueryParserHelper() {
    }

    public static Map<String, Float> parseFieldsAndWeights(List<String> fields) {
        HashMap<String, Float> fieldsAndWeights = new HashMap<String, Float>();
        for (String field : fields) {
            String fieldName;
            int boostIndex = field.indexOf(94);
            float boost = 1.0f;
            if (boostIndex != -1) {
                fieldName = field.substring(0, boostIndex);
                boost = Float.parseFloat(field.substring(boostIndex + 1, field.length()));
            } else {
                fieldName = field;
            }
            fieldsAndWeights.put(fieldName, Float.valueOf(boost));
        }
        return fieldsAndWeights;
    }

    public static FieldMapper getFieldMapper(MapperService mapperService, String field) {
        for (DocumentMapper mapper : mapperService.docMappers(true)) {
            FieldMapper fieldMapper = mapper.mappers().smartNameFieldMapper(field);
            if (fieldMapper == null) continue;
            return fieldMapper;
        }
        return null;
    }

    public static Map<String, Float> resolveMappingFields(QueryShardContext context, Map<String, Float> fieldsAndWeights) {
        return QueryParserHelper.resolveMappingFields(context, fieldsAndWeights, null);
    }

    public static Map<String, Float> resolveMappingFields(QueryShardContext context, Map<String, Float> fieldsAndWeights, String fieldSuffix) {
        HashMap<String, Float> resolvedFields = new HashMap<String, Float>();
        for (Map.Entry<String, Float> fieldEntry : fieldsAndWeights.entrySet()) {
            boolean allField = Regex.isMatchAllPattern(fieldEntry.getKey());
            boolean multiField = Regex.isSimpleMatchPattern(fieldEntry.getKey());
            float weight = fieldEntry.getValue() == null ? 1.0f : fieldEntry.getValue().floatValue();
            Map<String, Float> fieldMap = QueryParserHelper.resolveMappingField(context, fieldEntry.getKey(), weight, !multiField, !allField, fieldSuffix);
            resolvedFields.putAll(fieldMap);
        }
        return resolvedFields;
    }

    public static Map<String, Float> resolveMappingField(QueryShardContext context, String fieldOrPattern, float weight, boolean acceptAllTypes, boolean acceptMetadataField) {
        return QueryParserHelper.resolveMappingField(context, fieldOrPattern, weight, acceptAllTypes, acceptMetadataField, null);
    }

    public static Map<String, Float> resolveMappingField(QueryShardContext context, String fieldOrPattern, float weight, boolean acceptAllTypes, boolean acceptMetadataField, String fieldSuffix) {
        Collection<String> allFields = context.simpleMatchToIndexNames(fieldOrPattern);
        HashMap<String, Float> fields = new HashMap<String, Float>();
        for (String fieldName : allFields) {
            FieldMapper mapper;
            if (fieldSuffix != null && context.fieldMapper(fieldName + fieldSuffix) != null) {
                fieldName = fieldName + fieldSuffix;
            }
            if ((mapper = QueryParserHelper.getFieldMapper(context.getMapperService(), fieldName)) == null) {
                fields.put(fieldOrPattern, Float.valueOf(weight));
                continue;
            }
            if (!acceptMetadataField && mapper instanceof MetadataFieldMapper) continue;
            String mappingType = mapper.fieldType().typeName();
            if (!acceptAllTypes && !ALLOWED_QUERY_MAPPER_TYPES.contains(mappingType)) continue;
            fields.put(fieldName, Float.valueOf(weight));
        }
        return fields;
    }

    static {
        ALLOWED_QUERY_MAPPER_TYPES.add("date");
        ALLOWED_QUERY_MAPPER_TYPES.add("ip");
        ALLOWED_QUERY_MAPPER_TYPES.add("keyword");
        for (NumberFieldMapper.NumberType nt : NumberFieldMapper.NumberType.values()) {
            ALLOWED_QUERY_MAPPER_TYPES.add(nt.typeName());
        }
        ALLOWED_QUERY_MAPPER_TYPES.add("scaled_float");
        ALLOWED_QUERY_MAPPER_TYPES.add("text");
    }
}

