/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Map;
import java.util.function.Predicate;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MLMetadataField;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedJobValidator;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.datafeed.DatafeedManager;
import org.elasticsearch.xpack.ml.datafeed.DatafeedNodeSelector;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;

public class TransportStartDatafeedAction
extends TransportMasterNodeAction<StartDatafeedAction.Request, StartDatafeedAction.Response> {
    private final Client client;
    private final XPackLicenseState licenseState;
    private final PersistentTasksService persistentTasksService;

    @Inject
    public TransportStartDatafeedAction(Settings settings, TransportService transportService, ThreadPool threadPool, ClusterService clusterService, XPackLicenseState licenseState, PersistentTasksService persistentTasksService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(settings, "cluster:admin/xpack/ml/datafeed/start", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, StartDatafeedAction.Request::new);
        this.licenseState = licenseState;
        this.persistentTasksService = persistentTasksService;
        this.client = client;
    }

    static void validate(String datafeedId, MlMetadata mlMetadata, PersistentTasksCustomMetaData tasks) {
        DatafeedConfig datafeed;
        DatafeedConfig datafeedConfig = datafeed = mlMetadata == null ? null : mlMetadata.getDatafeed(datafeedId);
        if (datafeed == null) {
            throw ExceptionsHelper.missingDatafeedException((String)datafeedId);
        }
        Job job = (Job)mlMetadata.getJobs().get(datafeed.getJobId());
        if (job == null) {
            throw ExceptionsHelper.missingJobException((String)datafeed.getJobId());
        }
        DatafeedJobValidator.validate((DatafeedConfig)datafeed, (Job)job);
        JobState jobState = MlMetadata.getJobState((String)datafeed.getJobId(), (PersistentTasksCustomMetaData)tasks);
        if (!jobState.isAnyOf(new JobState[]{JobState.OPENING, JobState.OPENED})) {
            throw ExceptionsHelper.conflictStatusException((String)("cannot start datafeed [" + datafeedId + "] because job [" + job.getId() + "] is " + jobState), (Object[])new Object[0]);
        }
    }

    protected String executor() {
        return "same";
    }

    protected StartDatafeedAction.Response newResponse() {
        return new StartDatafeedAction.Response();
    }

    protected void masterOperation(StartDatafeedAction.Request request, ClusterState state, final ActionListener<StartDatafeedAction.Response> listener) {
        final StartDatafeedAction.DatafeedParams params = request.getParams();
        if (this.licenseState.isMachineLearningAllowed()) {
            ActionListener<PersistentTasksCustomMetaData.PersistentTask<StartDatafeedAction.DatafeedParams>> finalListener = new ActionListener<PersistentTasksCustomMetaData.PersistentTask<StartDatafeedAction.DatafeedParams>>(){

                public void onResponse(PersistentTasksCustomMetaData.PersistentTask<StartDatafeedAction.DatafeedParams> persistentTask) {
                    TransportStartDatafeedAction.this.waitForDatafeedStarted(persistentTask.getId(), params, (ActionListener<StartDatafeedAction.Response>)listener);
                }

                public void onFailure(Exception e) {
                    if (e instanceof ResourceAlreadyExistsException) {
                        TransportStartDatafeedAction.this.logger.debug("datafeed already started", (Throwable)e);
                        e = new ElasticsearchStatusException("cannot start datafeed [" + params.getDatafeedId() + "] because it has already been started", RestStatus.CONFLICT, new Object[0]);
                    }
                    listener.onFailure(e);
                }
            };
            MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)state);
            PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
            TransportStartDatafeedAction.validate(params.getDatafeedId(), mlMetadata, tasks);
            DatafeedConfig datafeed = mlMetadata.getDatafeed(params.getDatafeedId());
            Job job = (Job)mlMetadata.getJobs().get(datafeed.getJobId());
            DataExtractorFactory.create(this.client, datafeed, job, (ActionListener<DataExtractorFactory>)ActionListener.wrap(arg_0 -> this.lambda$masterOperation$0(params, (ActionListener)finalListener, arg_0), arg_0 -> listener.onFailure(arg_0)));
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
        }
    }

    protected ClusterBlockException checkBlock(StartDatafeedAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private void waitForDatafeedStarted(String taskId, final StartDatafeedAction.DatafeedParams params, final ActionListener<StartDatafeedAction.Response> listener) {
        final DatafeedPredicate predicate = new DatafeedPredicate();
        this.persistentTasksService.waitForPersistentTaskStatus(taskId, (Predicate)predicate, params.getTimeout(), (PersistentTasksService.WaitForPersistentTaskStatusListener)new PersistentTasksService.WaitForPersistentTaskStatusListener<StartDatafeedAction.DatafeedParams>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<StartDatafeedAction.DatafeedParams> persistentTask) {
                if (predicate.exception != null) {
                    TransportStartDatafeedAction.this.cancelDatafeedStart((PersistentTasksCustomMetaData.PersistentTask<StartDatafeedAction.DatafeedParams>)persistentTask, predicate.exception, (ActionListener<StartDatafeedAction.Response>)listener);
                } else {
                    listener.onResponse((Object)new StartDatafeedAction.Response(true));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void onTimeout(TimeValue timeout) {
                listener.onFailure((Exception)new ElasticsearchException("Starting datafeed [" + params.getDatafeedId() + "] timed out after [" + timeout + "]", new Object[0]));
            }
        });
    }

    private void cancelDatafeedStart(final PersistentTasksCustomMetaData.PersistentTask<StartDatafeedAction.DatafeedParams> persistentTask, final Exception exception, final ActionListener<StartDatafeedAction.Response> listener) {
        this.persistentTasksService.cancelPersistentTask(persistentTask.getId(), new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> task) {
                listener.onFailure(exception);
            }

            public void onFailure(Exception e) {
                TransportStartDatafeedAction.this.logger.error("[" + ((StartDatafeedAction.DatafeedParams)persistentTask.getParams()).getDatafeedId() + "] Failed to cancel persistent task that could not be assigned due to [" + exception.getMessage() + "]", (Throwable)e);
                listener.onFailure(exception);
            }
        });
    }

    private /* synthetic */ void lambda$masterOperation$0(StartDatafeedAction.DatafeedParams params, ActionListener finalListener, DataExtractorFactory dataExtractorFactory) throws Exception {
        this.persistentTasksService.startPersistentTask(MLMetadataField.datafeedTaskId((String)params.getDatafeedId()), "xpack/ml/datafeed", (PersistentTaskParams)params, finalListener);
    }

    private class DatafeedPredicate
    implements Predicate<PersistentTasksCustomMetaData.PersistentTask<?>> {
        private volatile Exception exception;

        private DatafeedPredicate() {
        }

        @Override
        public boolean test(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
            if (persistentTask == null) {
                return false;
            }
            PersistentTasksCustomMetaData.Assignment assignment = persistentTask.getAssignment();
            if (assignment != null && !assignment.equals((Object)PersistentTasksCustomMetaData.INITIAL_ASSIGNMENT) && !assignment.isAssigned()) {
                this.exception = new ElasticsearchStatusException("Could not start datafeed, allocation explanation [" + assignment.getExplanation() + "]", RestStatus.TOO_MANY_REQUESTS, new Object[0]);
                return true;
            }
            DatafeedState datafeedState = (DatafeedState)persistentTask.getStatus();
            return datafeedState == DatafeedState.STARTED;
        }
    }

    public static class DatafeedTask
    extends AllocatedPersistentTask
    implements StartDatafeedAction.DatafeedTaskMatcher {
        private final String datafeedId;
        private final long startTime;
        private final Long endTime;
        volatile DatafeedManager datafeedManager;

        DatafeedTask(long id, String type, String action, TaskId parentTaskId, StartDatafeedAction.DatafeedParams params, Map<String, String> headers) {
            super(id, type, action, "datafeed-" + params.getDatafeedId(), parentTaskId, headers);
            this.datafeedId = params.getDatafeedId();
            this.startTime = params.getStartTime();
            this.endTime = params.getEndTime();
        }

        public String getDatafeedId() {
            return this.datafeedId;
        }

        public long getDatafeedStartTime() {
            return this.startTime;
        }

        @Nullable
        public Long getEndTime() {
            return this.endTime;
        }

        public boolean isLookbackOnly() {
            return this.endTime != null;
        }

        protected void onCancelled() {
            this.stop(this.getReasonCancelled(), TimeValue.ZERO);
        }

        public void stop(String reason, TimeValue timeout) {
            if (this.datafeedManager != null) {
                this.datafeedManager.stopDatafeed(this, reason, timeout);
            }
        }

        public void isolate() {
            if (this.datafeedManager != null) {
                this.datafeedManager.isolateDatafeed(this.getAllocationId());
            }
        }
    }

    public static class StartDatafeedPersistentTasksExecutor
    extends PersistentTasksExecutor<StartDatafeedAction.DatafeedParams> {
        private final DatafeedManager datafeedManager;
        private final IndexNameExpressionResolver resolver;

        public StartDatafeedPersistentTasksExecutor(Settings settings, DatafeedManager datafeedManager) {
            super(settings, "xpack/ml/datafeed", "ml_utility");
            this.datafeedManager = datafeedManager;
            this.resolver = new IndexNameExpressionResolver(settings);
        }

        public PersistentTasksCustomMetaData.Assignment getAssignment(StartDatafeedAction.DatafeedParams params, ClusterState clusterState) {
            return new DatafeedNodeSelector(clusterState, this.resolver, params.getDatafeedId()).selectNode();
        }

        public void validate(StartDatafeedAction.DatafeedParams params, ClusterState clusterState) {
            PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)clusterState.getMetaData().custom("persistent_tasks");
            TransportStartDatafeedAction.validate(params.getDatafeedId(), MlMetadata.getMlMetadata((ClusterState)clusterState), tasks);
            new DatafeedNodeSelector(clusterState, this.resolver, params.getDatafeedId()).checkDatafeedTaskCanBeCreated();
        }

        protected void nodeOperation(AllocatedPersistentTask allocatedPersistentTask, StartDatafeedAction.DatafeedParams params, Task.Status status) {
            DatafeedTask datafeedTask = (DatafeedTask)allocatedPersistentTask;
            datafeedTask.datafeedManager = this.datafeedManager;
            this.datafeedManager.run(datafeedTask, error -> {
                if (error != null) {
                    datafeedTask.markAsFailed((Exception)error);
                } else {
                    datafeedTask.markAsCompleted();
                }
            });
        }

        protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetaData.PersistentTask<StartDatafeedAction.DatafeedParams> persistentTask, Map<String, String> headers) {
            return new DatafeedTask(id, type, action, parentTaskId, (StartDatafeedAction.DatafeedParams)persistentTask.getParams(), headers);
        }
    }
}

