/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule.engine;

import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.watcher.trigger.schedule.Schedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.ScheduleRegistry;
import org.elasticsearch.xpack.watcher.trigger.schedule.ScheduleTrigger;
import org.elasticsearch.xpack.watcher.trigger.schedule.ScheduleTriggerEngine;
import org.elasticsearch.xpack.watcher.trigger.schedule.ScheduleTriggerEvent;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TickerScheduleTriggerEngine
extends ScheduleTriggerEngine {
    public static final Setting<TimeValue> TICKER_INTERVAL_SETTING = Setting.positiveTimeSetting((String)"xpack.watcher.trigger.schedule.ticker.tick_interval", (TimeValue)TimeValue.timeValueMillis((long)500L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final TimeValue tickInterval;
    private volatile Map<String, ActiveSchedule> schedules;
    private Ticker ticker;

    public TickerScheduleTriggerEngine(Settings settings, ScheduleRegistry scheduleRegistry, Clock clock) {
        super(settings, scheduleRegistry, clock);
        this.tickInterval = (TimeValue)TICKER_INTERVAL_SETTING.get(settings);
        this.schedules = new ConcurrentHashMap<String, ActiveSchedule>();
    }

    @Override
    public void start(Collection<Watch> jobs) {
        long starTime = this.clock.millis();
        ConcurrentHashMap<String, ActiveSchedule> schedules = new ConcurrentHashMap<String, ActiveSchedule>();
        for (Watch job : jobs) {
            if (!(job.trigger() instanceof ScheduleTrigger)) continue;
            ScheduleTrigger trigger = (ScheduleTrigger)job.trigger();
            schedules.put(job.id(), new ActiveSchedule(job.id(), trigger.getSchedule(), starTime));
        }
        this.schedules = schedules;
        this.ticker = new Ticker();
    }

    @Override
    public void stop() {
        this.ticker.close();
        this.pauseExecution();
    }

    @Override
    public void add(Watch watch) {
        assert (watch.trigger() instanceof ScheduleTrigger);
        ScheduleTrigger trigger = (ScheduleTrigger)watch.trigger();
        this.schedules.put(watch.id(), new ActiveSchedule(watch.id(), trigger.getSchedule(), this.clock.millis()));
    }

    @Override
    public void pauseExecution() {
        this.schedules.clear();
    }

    @Override
    public int getJobCount() {
        return this.schedules.size();
    }

    @Override
    public boolean remove(String jobId) {
        return this.schedules.remove(jobId) != null;
    }

    void checkJobs() {
        long triggeredTime = this.clock.millis();
        ArrayList<TriggerEvent> events = new ArrayList<TriggerEvent>();
        for (ActiveSchedule schedule : this.schedules.values()) {
            long scheduledTime = schedule.check(triggeredTime);
            if (scheduledTime <= 0L) continue;
            this.logger.debug("triggered job [{}] at [{}] (scheduled time was [{}])", (Object)schedule.name, (Object)new DateTime(triggeredTime, DateTimeZone.UTC), (Object)new DateTime(scheduledTime, DateTimeZone.UTC));
            events.add(new ScheduleTriggerEvent(schedule.name, new DateTime(triggeredTime, DateTimeZone.UTC), new DateTime(scheduledTime, DateTimeZone.UTC)));
            if (events.size() < 1000) continue;
            this.notifyListeners(events);
            events.clear();
        }
        if (!events.isEmpty()) {
            this.notifyListeners(events);
        }
    }

    protected void notifyListeners(List<TriggerEvent> events) {
        this.consumers.forEach(consumer -> consumer.accept(events));
    }

    class Ticker
    extends Thread {
        private volatile boolean active;
        private final CountDownLatch closeLatch;

        Ticker() {
            super("ticker-schedule-trigger-engine");
            this.active = true;
            this.closeLatch = new CountDownLatch(1);
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            while (this.active) {
                TickerScheduleTriggerEngine.this.logger.trace("checking jobs [{}]", (Object)new DateTime(TickerScheduleTriggerEngine.this.clock.millis(), DateTimeZone.UTC));
                TickerScheduleTriggerEngine.this.checkJobs();
                try {
                    Ticker.sleep(TickerScheduleTriggerEngine.this.tickInterval.millis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.closeLatch.countDown();
        }

        public void close() {
            TickerScheduleTriggerEngine.this.logger.trace("stopping ticker thread");
            this.active = false;
            try {
                this.closeLatch.await();
            }
            catch (InterruptedException e) {
                TickerScheduleTriggerEngine.this.logger.warn("caught an interrupted exception when waiting while closing ticker thread", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            TickerScheduleTriggerEngine.this.logger.trace("ticker thread stopped");
        }
    }

    static class ActiveSchedule {
        private final String name;
        private final Schedule schedule;
        private final long startTime;
        private volatile long scheduledTime;

        ActiveSchedule(String name, Schedule schedule, long startTime) {
            this.name = name;
            this.schedule = schedule;
            this.startTime = startTime;
            this.scheduledTime = schedule.nextScheduledTimeAfter(startTime, startTime);
        }

        public long check(long time) {
            if (time < this.scheduledTime) {
                return -1L;
            }
            long prevScheduledTime = this.scheduledTime == 0L ? time : this.scheduledTime;
            this.scheduledTime = this.schedule.nextScheduledTimeAfter(this.startTime, time);
            return prevScheduledTime;
        }
    }
}

