/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.watcher.execution.ExecutionService;

public class SyncTriggerEventConsumer
implements Consumer<Iterable<TriggerEvent>> {
    private final ExecutionService executionService;
    private final Logger logger;

    public SyncTriggerEventConsumer(Settings settings, ExecutionService executionService) {
        this.logger = Loggers.getLogger(SyncTriggerEventConsumer.class, (Settings)settings, (String[])new String[0]);
        this.executionService = executionService;
    }

    @Override
    public void accept(Iterable<TriggerEvent> events) {
        try {
            this.executionService.processEventsSync(events);
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("failed to process triggered events [{}]", StreamSupport.stream(events.spliterator(), false).toArray(TriggerEvent[]::new)), (Throwable)e);
        }
    }
}

