/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml;

import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;

public class MlClientHelper {
    public static final Set<String> SECURITY_HEADER_FILTERS = Sets.newHashSet((Object[])new String[]{"es-security-runas-user", "_xpack_security_authentication"});

    public static <T extends ActionResponse> T execute(DatafeedConfig datafeedConfig, Client client, Supplier<T> supplier) {
        return MlClientHelper.execute(datafeedConfig.getHeaders(), client, supplier);
    }

    public static <T extends ActionResponse> T execute(Map<String, String> headers, Client client, Supplier<T> supplier) {
        if (headers == null || headers.isEmpty()) {
            try (ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin(client.threadPool().getThreadContext(), "ml");){
                ActionResponse actionResponse = (ActionResponse)supplier.get();
                return (T)actionResponse;
            }
        }
        try (ThreadContext.StoredContext ignore = client.threadPool().getThreadContext().stashContext();){
            Map<String, String> filteredHeaders = headers.entrySet().stream().filter(e -> SECURITY_HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            client.threadPool().getThreadContext().copyHeaders(filteredHeaders.entrySet());
            ActionResponse actionResponse = (ActionResponse)supplier.get();
            return (T)actionResponse;
        }
    }
}

