/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.file;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.support.NoOpLogger;
import org.elasticsearch.xpack.core.security.support.Validation;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.support.SecurityFiles;

public class FileUserPasswdStore {
    private final Logger logger;
    private final Path file;
    private final Hasher hasher = Hasher.BCRYPT;
    private final Settings settings;
    private final CopyOnWriteArrayList<Runnable> listeners;
    private volatile Map<String, char[]> users;

    public FileUserPasswdStore(RealmConfig config, ResourceWatcherService watcherService) {
        this(config, watcherService, () -> {});
    }

    FileUserPasswdStore(RealmConfig config, ResourceWatcherService watcherService, Runnable listener) {
        this.logger = config.logger(FileUserPasswdStore.class);
        this.file = FileUserPasswdStore.resolveFile(config.env());
        this.settings = config.globalSettings();
        this.users = FileUserPasswdStore.parseFileLenient(this.file, this.logger, this.settings);
        this.listeners = new CopyOnWriteArrayList<Runnable>(Collections.singletonList(listener));
        FileWatcher watcher = new FileWatcher(this.file.getParent());
        watcher.addListener((Object)new FileListener());
        try {
            watcherService.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.HIGH);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to start watching users file [{}]", (Throwable)e, new Object[]{this.file.toAbsolutePath()});
        }
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    public int usersCount() {
        return this.users.size();
    }

    public AuthenticationResult verifyPassword(String username, SecureString password, Supplier<User> user) {
        char[] hash = this.users.get(username);
        if (hash == null) {
            return AuthenticationResult.notHandled();
        }
        if (!this.hasher.verify(password, hash)) {
            return AuthenticationResult.unsuccessful((String)("Password authentication failed for " + username), null);
        }
        return AuthenticationResult.success((User)user.get());
    }

    public boolean userExists(String username) {
        return this.users.containsKey(username);
    }

    public static Path resolveFile(Environment env) {
        return XPackPlugin.resolveConfigFile((Environment)env, (String)"users");
    }

    static Map<String, char[]> parseFileLenient(Path path, Logger logger, Settings settings) {
        try {
            Map<String, char[]> map = FileUserPasswdStore.parseFile(path, logger, settings);
            return map == null ? Collections.emptyMap() : map;
        }
        catch (Exception e) {
            logger.error(() -> new ParameterizedMessage("failed to parse users file [{}]. skipping/removing all users...", (Object)path.toAbsolutePath()), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static Map<String, char[]> parseFile(Path path, @Nullable Logger logger, Settings settings) {
        List<String> lines;
        if (logger == null) {
            logger = NoOpLogger.INSTANCE;
        }
        logger.trace("reading users file [{}]...", (Object)path.toAbsolutePath());
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try {
            lines = Files.readAllLines(path, StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("could not read users file [" + path.toAbsolutePath() + "]", ioe);
        }
        HashMap<String, char[]> users = new HashMap<String, char[]>();
        boolean allowReserved = (Boolean)XPackSettings.RESERVED_REALM_ENABLED_SETTING.get(settings) == false;
        int lineNr = 0;
        for (String line : lines) {
            ++lineNr;
            if (line.startsWith("#")) continue;
            int i = (line = line.trim()).indexOf(":");
            if (i <= 0 || i == line.length() - 1) {
                logger.error("invalid entry in users file [{}], line [{}]. skipping...", (Object)path.toAbsolutePath(), (Object)lineNr);
                continue;
            }
            String username = line.substring(0, i);
            Validation.Error validationError = Validation.Users.validateUsername((String)username, (boolean)allowReserved, (Settings)settings);
            if (validationError != null) {
                logger.error("invalid username [{}] in users file [{}], skipping... ({})", (Object)username, (Object)path.toAbsolutePath(), (Object)validationError);
                continue;
            }
            String hash = line.substring(i + 1);
            users.put(username, hash.toCharArray());
        }
        logger.debug("parsed [{}] users from file [{}]", (Object)users.size(), (Object)path.toAbsolutePath());
        return Collections.unmodifiableMap(users);
    }

    public static void writeFile(Map<String, char[]> users, Path path) {
        SecurityFiles.writeFileAtomically(path, users, e -> String.format(Locale.ROOT, "%s:%s", e.getKey(), new String((char[])e.getValue())));
    }

    void notifyRefresh() {
        this.listeners.forEach(Runnable::run);
    }

    private class FileListener
    implements FileChangesListener {
        private FileListener() {
        }

        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        public void onFileDeleted(Path file) {
            this.onFileChanged(file);
        }

        public void onFileChanged(Path file) {
            if (file.equals(FileUserPasswdStore.this.file)) {
                FileUserPasswdStore.this.logger.info("users file [{}] changed. updating users... )", (Object)file.toAbsolutePath());
                FileUserPasswdStore.this.users = FileUserPasswdStore.parseFileLenient(file, FileUserPasswdStore.this.logger, FileUserPasswdStore.this.settings);
                FileUserPasswdStore.this.notifyRefresh();
            }
        }
    }
}

