/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.email.attachment;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.watcher.common.http.HttpRequestTemplate;
import org.elasticsearch.xpack.watcher.notification.email.attachment.EmailAttachmentParser;
import org.elasticsearch.xpack.watcher.notification.email.attachment.HttpEmailAttachementParser;

public class HttpRequestAttachment
implements EmailAttachmentParser.EmailAttachment {
    private final HttpRequestTemplate requestTemplate;
    private boolean inline;
    private final String contentType;
    private final String id;

    public HttpRequestAttachment(String id, HttpRequestTemplate requestTemplate, boolean inline, @Nullable String contentType) {
        this.id = id;
        this.requestTemplate = requestTemplate;
        this.inline = inline;
        this.contentType = contentType;
    }

    public HttpRequestTemplate getRequestTemplate() {
        return this.requestTemplate;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public boolean inline() {
        return this.inline;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.id).startObject("http").field(HttpEmailAttachementParser.Fields.REQUEST.getPreferredName(), (ToXContent)this.requestTemplate, params);
        if (Strings.hasLength((String)this.contentType)) {
            builder.field(HttpEmailAttachementParser.Fields.CONTENT_TYPE.getPreferredName(), this.contentType);
        }
        if (this.inline) {
            builder.field(HttpEmailAttachementParser.Fields.INLINE.getPreferredName(), this.inline);
        }
        return builder.endObject().endObject();
    }

    public static Builder builder(String id) {
        return new Builder(id);
    }

    @Override
    public String type() {
        return "http";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequestAttachment otherDataAttachment = (HttpRequestAttachment)o;
        return Objects.equals(this.id, otherDataAttachment.id) && Objects.equals(this.requestTemplate, otherDataAttachment.requestTemplate) && Objects.equals(this.contentType, otherDataAttachment.contentType) && Objects.equals(this.inline, otherDataAttachment.inline);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.requestTemplate, this.contentType, this.inline);
    }

    public static class Builder {
        private String id;
        private HttpRequestTemplate httpRequestTemplate;
        private String contentType;
        private boolean inline = false;

        private Builder(String id) {
            this.id = id;
        }

        public Builder httpRequestTemplate(HttpRequestTemplate httpRequestTemplate) {
            this.httpRequestTemplate = httpRequestTemplate;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder inline(boolean inline) {
            this.inline = inline;
            return this;
        }

        public HttpRequestAttachment build() {
            return new HttpRequestAttachment(this.id, this.httpRequestTemplate, this.inline, this.contentType);
        }
    }
}

