/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ingest.WriteableIngestDocument;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.ingest.IngestDocument;

class SimulateProcessorResult
implements Writeable,
ToXContentObject {
    private final String processorTag;
    private final WriteableIngestDocument ingestDocument;
    private final Exception failure;

    SimulateProcessorResult(String processorTag, IngestDocument ingestDocument, Exception failure) {
        this.processorTag = processorTag;
        this.ingestDocument = ingestDocument == null ? null : new WriteableIngestDocument(ingestDocument);
        this.failure = failure;
    }

    SimulateProcessorResult(String processorTag, IngestDocument ingestDocument) {
        this(processorTag, ingestDocument, null);
    }

    SimulateProcessorResult(String processorTag, Exception failure) {
        this(processorTag, null, failure);
    }

    SimulateProcessorResult(StreamInput in) throws IOException {
        this.processorTag = in.readString();
        this.ingestDocument = in.readBoolean() ? new WriteableIngestDocument(in) : null;
        this.failure = in.readException();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.processorTag);
        if (this.ingestDocument == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.ingestDocument.writeTo(out);
        }
        out.writeException(this.failure);
    }

    public IngestDocument getIngestDocument() {
        if (this.ingestDocument == null) {
            return null;
        }
        return this.ingestDocument.getIngestDocument();
    }

    public String getProcessorTag() {
        return this.processorTag;
    }

    public Exception getFailure() {
        return this.failure;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.processorTag != null) {
            builder.field("tag", this.processorTag);
        }
        if (this.failure != null && this.ingestDocument != null) {
            builder.startObject("ignored_error");
            ElasticsearchException.generateFailureXContent(builder, params, this.failure, true);
            builder.endObject();
        } else if (this.failure != null) {
            ElasticsearchException.generateFailureXContent(builder, params, this.failure, true);
        }
        if (this.ingestDocument != null) {
            this.ingestDocument.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }
}

