/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.RestStatus;

public class SqlClearCursorResponse
extends ActionResponse
implements StatusToXContentObject {
    private static final ParseField SUCCEEDED = new ParseField("succeeded", new String[0]);
    public static final ObjectParser<SqlClearCursorResponse, Void> PARSER = new ObjectParser("indices:data/read/sql/close_cursor", true, SqlClearCursorResponse::new);
    private boolean succeeded;

    public SqlClearCursorResponse(boolean succeeded) {
        this.succeeded = succeeded;
    }

    SqlClearCursorResponse() {
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    public SqlClearCursorResponse setSucceeded(boolean succeeded) {
        this.succeeded = succeeded;
        return this;
    }

    public RestStatus status() {
        return this.succeeded ? RestStatus.NOT_FOUND : RestStatus.OK;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SUCCEEDED.getPreferredName(), this.succeeded);
        builder.endObject();
        return builder;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.succeeded = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.succeeded);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SqlClearCursorResponse response = (SqlClearCursorResponse)((Object)o);
        return this.succeeded == response.succeeded;
    }

    public int hashCode() {
        return Objects.hash(this.succeeded);
    }

    public static SqlClearCursorResponse fromXContent(XContentParser parser) {
        return (SqlClearCursorResponse)((Object)PARSER.apply(parser, null));
    }

    static {
        PARSER.declareBoolean(SqlClearCursorResponse::setSucceeded, SUCCEEDED);
    }
}

