/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.internal.SearchContext;

public abstract class AggregatorFactory<AF extends AggregatorFactory<AF>> {
    protected final String name;
    protected final AggregatorFactory<?> parent;
    protected final AggregatorFactories factories;
    protected final Map<String, Object> metaData;
    protected final SearchContext context;

    public AggregatorFactory(String name, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        this.name = name;
        this.context = context;
        this.parent = parent;
        this.factories = subFactoriesBuilder.build(context, this);
        this.metaData = metaData;
    }

    public String name() {
        return this.name;
    }

    public void doValidate() {
    }

    protected abstract Aggregator createInternal(Aggregator var1, boolean var2, List<PipelineAggregator> var3, Map<String, Object> var4) throws IOException;

    public final Aggregator create(Aggregator parent, boolean collectsFromSingleBucket) throws IOException {
        return this.createInternal(parent, collectsFromSingleBucket, this.factories.createPipelineAggregators(), this.metaData);
    }

    public AggregatorFactory<?> getParent() {
        return this.parent;
    }

    protected static Aggregator asMultiBucketAggregator(AggregatorFactory<?> factory, SearchContext context, Aggregator parent) throws IOException {
        Aggregator first = factory.create(parent, true);
        BigArrays bigArrays = context.bigArrays();
        return new MultiBucketAggregatorWrapper(bigArrays, context, parent, factory, first);
    }

    public static final class MultiBucketAggregatorWrapper
    extends Aggregator {
        private final BigArrays bigArrays;
        private final Aggregator parent;
        private final AggregatorFactory<?> factory;
        private final Aggregator first;
        ObjectArray<Aggregator> aggregators;
        ObjectArray<LeafBucketCollector> collectors;

        MultiBucketAggregatorWrapper(BigArrays bigArrays, SearchContext context, Aggregator parent, AggregatorFactory<?> factory, Aggregator first) {
            this.bigArrays = bigArrays;
            this.parent = parent;
            this.factory = factory;
            this.first = first;
            context.addReleasable(this, SearchContext.Lifetime.PHASE);
            this.aggregators = bigArrays.newObjectArray(1L);
            this.aggregators.set(0L, first);
            this.collectors = bigArrays.newObjectArray(1L);
        }

        public Class<?> getWrappedClass() {
            return this.first.getClass();
        }

        @Override
        public String name() {
            return this.first.name();
        }

        @Override
        public SearchContext context() {
            return this.first.context();
        }

        @Override
        public Aggregator parent() {
            return this.first.parent();
        }

        @Override
        public boolean needsScores() {
            return this.first.needsScores();
        }

        @Override
        public Aggregator subAggregator(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void preCollection() throws IOException {
            for (long i = 0L; i < this.aggregators.size(); ++i) {
                Aggregator aggregator = this.aggregators.get(i);
                if (aggregator == null) continue;
                aggregator.preCollection();
            }
        }

        @Override
        public void postCollection() throws IOException {
            for (long i = 0L; i < this.aggregators.size(); ++i) {
                Aggregator aggregator = this.aggregators.get(i);
                if (aggregator == null) continue;
                aggregator.postCollection();
            }
        }

        @Override
        public LeafBucketCollector getLeafCollector(final LeafReaderContext ctx) {
            for (long i = 0L; i < this.collectors.size(); ++i) {
                this.collectors.set(i, null);
            }
            return new LeafBucketCollector(){
                Scorer scorer;

                @Override
                public void setScorer(Scorer scorer) throws IOException {
                    this.scorer = scorer;
                }

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    collectors = bigArrays.grow(collectors, bucket + 1L);
                    LeafBucketCollector collector = collectors.get(bucket);
                    if (collector == null) {
                        aggregators = bigArrays.grow(aggregators, bucket + 1L);
                        Aggregator aggregator = aggregators.get(bucket);
                        if (aggregator == null) {
                            aggregator = factory.create(parent, true);
                            aggregator.preCollection();
                            aggregators.set(bucket, aggregator);
                        }
                        collector = aggregator.getLeafCollector(ctx);
                        if (this.scorer != null) {
                            collector.setScorer(this.scorer);
                        }
                        collectors.set(bucket, collector);
                    }
                    collector.collect(doc, 0L);
                }
            };
        }

        @Override
        public InternalAggregation buildAggregation(long bucket) throws IOException {
            Aggregator aggregator;
            if (bucket < this.aggregators.size() && (aggregator = this.aggregators.get(bucket)) != null) {
                return aggregator.buildAggregation(0L);
            }
            return this.buildEmptyAggregation();
        }

        @Override
        public InternalAggregation buildEmptyAggregation() {
            return this.first.buildEmptyAggregation();
        }

        @Override
        public void close() {
            Releasables.close(this.aggregators, this.collectors);
        }
    }
}

