/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.CommandLineToolInteractiveModeProcessor;
import com.unboundid.util.CommandLineToolShutdownHook;
import com.unboundid.util.Debug;
import com.unboundid.util.ExampleCommandLineArgument;
import com.unboundid.util.Extensible;
import com.unboundid.util.LDAPSDKUsageException;
import com.unboundid.util.NullOutputStream;
import com.unboundid.util.SASLUtils;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.TeeOutputStream;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.SubCommand;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public abstract class CommandLineTool {
    private final PrintStream originalOut;
    private final PrintStream originalErr;
    private volatile PrintStream out;
    private volatile PrintStream err;
    private BooleanArgument appendToOutputFileArgument = null;
    private BooleanArgument helpArgument = null;
    private BooleanArgument helpSASLArgument = null;
    private BooleanArgument helpSubcommandsArgument = null;
    private BooleanArgument interactiveArgument = null;
    private BooleanArgument teeOutputArgument = null;
    private BooleanArgument versionArgument = null;
    private FileArgument outputFileArgument = null;

    public CommandLineTool(OutputStream outStream, OutputStream errStream) {
        this.out = outStream == null ? NullOutputStream.getPrintStream() : new PrintStream(outStream);
        this.err = errStream == null ? NullOutputStream.getPrintStream() : new PrintStream(errStream);
        this.originalOut = this.out;
        this.originalErr = this.err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ResultCode runTool(String ... args) {
        List<String> argsSetFromPropertiesFiles;
        ArgumentParser parser;
        try {
            parser = this.createArgumentParser();
            if (!this.supportsInteractiveMode() || !this.defaultsToInteractiveMode() || args != null && args.length != 0) {
                parser.parse(args);
            }
            File generatedPropertiesFile = parser.getGeneratedPropertiesFile();
            if (this.supportsPropertiesFile() && generatedPropertiesFile != null) {
                this.wrapOut(0, StaticUtils.TERMINAL_WIDTH_COLUMNS - 1, UtilityMessages.INFO_CL_TOOL_WROTE_PROPERTIES_FILE.get(generatedPropertiesFile.getAbsolutePath()));
                return ResultCode.SUCCESS;
            }
            if (this.helpArgument.isPresent()) {
                this.out(parser.getUsageString(StaticUtils.TERMINAL_WIDTH_COLUMNS - 1));
                this.displayExampleUsages(parser);
                return ResultCode.SUCCESS;
            }
            if (this.helpSASLArgument != null && this.helpSASLArgument.isPresent()) {
                this.out(SASLUtils.getUsageString(StaticUtils.TERMINAL_WIDTH_COLUMNS - 1));
                return ResultCode.SUCCESS;
            }
            if (this.helpSubcommandsArgument != null && this.helpSubcommandsArgument.isPresent()) {
                TreeMap<String, SubCommand> subCommands = CommandLineTool.getSortedSubCommands(parser);
                Iterator<SubCommand> i$ = subCommands.values().iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        this.wrapOut(0, StaticUtils.TERMINAL_WIDTH_COLUMNS - 1, UtilityMessages.INFO_CL_TOOL_USE_SUBCOMMAND_HELP.get(this.getToolName()));
                        return ResultCode.SUCCESS;
                    }
                    SubCommand sc = i$.next();
                    StringBuilder nameBuffer = new StringBuilder();
                    Iterator<String> nameIterator = sc.getNames().iterator();
                    while (nameIterator.hasNext()) {
                        nameBuffer.append(nameIterator.next());
                        if (!nameIterator.hasNext()) continue;
                        nameBuffer.append(", ");
                    }
                    this.out(nameBuffer.toString());
                    for (String descriptionLine : StaticUtils.wrapLine(sc.getDescription(), StaticUtils.TERMINAL_WIDTH_COLUMNS - 3)) {
                        this.out("  " + descriptionLine);
                    }
                    this.out(new Object[0]);
                }
            }
            if (this.versionArgument != null && this.versionArgument.isPresent()) {
                this.out(this.getToolVersion());
                return ResultCode.SUCCESS;
            }
            boolean extendedValidationDone = false;
            if (this.interactiveArgument != null && (this.interactiveArgument.isPresent() || this.defaultsToInteractiveMode() && (args == null || args.length == 0))) {
                CommandLineToolInteractiveModeProcessor interactiveProcessor = new CommandLineToolInteractiveModeProcessor(this, parser);
                try {
                    interactiveProcessor.doInteractiveModeProcessing();
                    extendedValidationDone = true;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    String message = le.getMessage();
                    if (message == null) return le.getResultCode();
                    if (message.length() <= 0) return le.getResultCode();
                    this.err(message);
                    return le.getResultCode();
                }
            }
            if (!extendedValidationDone) {
                this.doExtendedArgumentValidation();
            }
        }
        catch (ArgumentException ae) {
            Debug.debugException(ae);
            this.err(ae.getMessage());
            return ResultCode.PARAM_ERROR;
        }
        if (this.outputFileArgument != null && this.outputFileArgument.isPresent()) {
            PrintStream outputFileStream;
            File outputFile = this.outputFileArgument.getValue();
            boolean append = this.appendToOutputFileArgument != null && this.appendToOutputFileArgument.isPresent();
            try {
                FileOutputStream fos = new FileOutputStream(outputFile, append);
                outputFileStream = new PrintStream((OutputStream)fos, true, "UTF-8");
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.err(UtilityMessages.ERR_CL_TOOL_ERROR_CREATING_OUTPUT_FILE.get(outputFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
                return ResultCode.LOCAL_ERROR;
            }
            if (this.teeOutputArgument != null && this.teeOutputArgument.isPresent()) {
                this.out = new PrintStream(new TeeOutputStream(this.out, outputFileStream));
                this.err = new PrintStream(new TeeOutputStream(this.err, outputFileStream));
            } else {
                this.out = outputFileStream;
                this.err = outputFileStream;
            }
        }
        if (!(argsSetFromPropertiesFiles = parser.getArgumentsSetFromPropertiesFile()).isEmpty()) {
            for (String line : StaticUtils.wrapLine(UtilityMessages.INFO_CL_TOOL_ARGS_FROM_PROPERTIES_FILE.get(parser.getPropertiesFileUsed().getPath()), StaticUtils.TERMINAL_WIDTH_COLUMNS - 3)) {
                this.out("# ", line);
            }
            StringBuilder buffer = new StringBuilder();
            for (String s : argsSetFromPropertiesFiles) {
                if (s.startsWith("-")) {
                    if (buffer.length() > 0) {
                        this.out(buffer);
                        buffer.setLength(0);
                    }
                    buffer.append("#      ");
                    buffer.append(s);
                    continue;
                }
                if (buffer.length() == 0) {
                    buffer.append("#      ");
                } else {
                    buffer.append(' ');
                }
                buffer.append(StaticUtils.cleanExampleCommandLineArgument(s));
            }
            if (buffer.length() > 0) {
                this.out(buffer);
            }
            this.out(new Object[0]);
        }
        CommandLineToolShutdownHook shutdownHook = null;
        AtomicReference<ResultCode> exitCode = new AtomicReference<ResultCode>();
        if (this.registerShutdownHook()) {
            shutdownHook = new CommandLineToolShutdownHook(this, exitCode);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
        try {
            try {
                exitCode.set(this.doToolProcessing());
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.err(StaticUtils.getExceptionMessage(e));
                exitCode.set(ResultCode.LOCAL_ERROR);
                Object var12_22 = null;
                if (shutdownHook == null) return exitCode.get();
                Runtime.getRuntime().removeShutdownHook(shutdownHook);
                return exitCode.get();
            }
            Object var12_21 = null;
            if (shutdownHook == null) return exitCode.get();
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
            return exitCode.get();
        }
        catch (Throwable throwable) {
            Object var12_23 = null;
            if (shutdownHook == null) throw throwable;
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
            throw throwable;
        }
    }

    private static TreeMap<String, SubCommand> getSortedSubCommands(ArgumentParser parser) {
        TreeMap<String, SubCommand> m = new TreeMap<String, SubCommand>();
        for (SubCommand sc : parser.getSubCommands()) {
            m.put(sc.getPrimaryName(), sc);
        }
        return m;
    }

    private void displayExampleUsages(ArgumentParser parser) {
        LinkedHashMap<String[], String> examples = parser != null && parser.getSelectedSubCommand() != null ? parser.getSelectedSubCommand().getExampleUsages() : this.getExampleUsages();
        if (examples == null || examples.isEmpty()) {
            return;
        }
        this.out(new Object[]{UtilityMessages.INFO_CL_TOOL_LABEL_EXAMPLES});
        int wrapWidth = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
        for (Map.Entry<String[], String> e : examples.entrySet()) {
            this.out(new Object[0]);
            this.wrapOut(2, wrapWidth, e.getValue());
            this.out(new Object[0]);
            StringBuilder buffer = new StringBuilder();
            buffer.append("    ");
            buffer.append(this.getToolName());
            String[] args = e.getKey();
            for (int i = 0; i < args.length; ++i) {
                ExampleCommandLineArgument cleanArg;
                buffer.append(' ');
                String arg = args[i];
                if (arg.startsWith("-")) {
                    if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                        cleanArg = ExampleCommandLineArgument.getCleanArgument(args[i + 1]);
                        arg = arg + ' ' + cleanArg.getLocalForm();
                        ++i;
                    }
                } else {
                    cleanArg = ExampleCommandLineArgument.getCleanArgument(arg);
                    arg = cleanArg.getLocalForm();
                }
                if (buffer.length() + arg.length() + 2 < wrapWidth) {
                    buffer.append(arg);
                    continue;
                }
                buffer.append('\\');
                this.out(buffer.toString());
                buffer.setLength(0);
                buffer.append("         ");
                buffer.append(arg);
            }
            this.out(buffer.toString());
        }
    }

    public abstract String getToolName();

    public abstract String getToolDescription();

    public String getToolVersion() {
        return null;
    }

    public int getMinTrailingArguments() {
        return 0;
    }

    public int getMaxTrailingArguments() {
        return 0;
    }

    public String getTrailingArgumentsPlaceholder() {
        return null;
    }

    public boolean supportsInteractiveMode() {
        return false;
    }

    public boolean defaultsToInteractiveMode() {
        return false;
    }

    public boolean supportsPropertiesFile() {
        return false;
    }

    protected boolean supportsOutputFile() {
        return false;
    }

    public final ArgumentParser createArgumentParser() throws ArgumentException {
        String version;
        ArgumentParser parser = new ArgumentParser(this.getToolName(), this.getToolDescription(), this.getMinTrailingArguments(), this.getMaxTrailingArguments(), this.getTrailingArgumentsPlaceholder());
        this.addToolArguments(parser);
        if (this.supportsInteractiveMode()) {
            this.interactiveArgument = new BooleanArgument(null, "interactive", UtilityMessages.INFO_CL_TOOL_DESCRIPTION_INTERACTIVE.get());
            this.interactiveArgument.setUsageArgument(true);
            parser.addArgument(this.interactiveArgument);
        }
        if (this.supportsOutputFile()) {
            this.outputFileArgument = new FileArgument(null, "outputFile", false, 1, null, UtilityMessages.INFO_CL_TOOL_DESCRIPTION_OUTPUT_FILE.get(), false, true, true, false);
            this.outputFileArgument.addLongIdentifier("output-file");
            this.outputFileArgument.setUsageArgument(true);
            parser.addArgument(this.outputFileArgument);
            this.appendToOutputFileArgument = new BooleanArgument(null, "appendToOutputFile", 1, UtilityMessages.INFO_CL_TOOL_DESCRIPTION_APPEND_TO_OUTPUT_FILE.get(this.outputFileArgument.getIdentifierString()));
            this.appendToOutputFileArgument.addLongIdentifier("append-to-output-file");
            this.appendToOutputFileArgument.setUsageArgument(true);
            parser.addArgument(this.appendToOutputFileArgument);
            this.teeOutputArgument = new BooleanArgument(null, "teeOutput", 1, UtilityMessages.INFO_CL_TOOL_DESCRIPTION_TEE_OUTPUT.get(this.outputFileArgument.getIdentifierString()));
            this.teeOutputArgument.addLongIdentifier("tee-output");
            this.teeOutputArgument.setUsageArgument(true);
            parser.addArgument(this.teeOutputArgument);
            parser.addDependentArgumentSet(this.appendToOutputFileArgument, this.outputFileArgument, new Argument[0]);
            parser.addDependentArgumentSet(this.teeOutputArgument, this.outputFileArgument, new Argument[0]);
        }
        this.helpArgument = new BooleanArgument(Character.valueOf('H'), "help", UtilityMessages.INFO_CL_TOOL_DESCRIPTION_HELP.get());
        this.helpArgument.addShortIdentifier(Character.valueOf('?'));
        this.helpArgument.setUsageArgument(true);
        parser.addArgument(this.helpArgument);
        if (!parser.getSubCommands().isEmpty()) {
            this.helpSubcommandsArgument = new BooleanArgument(null, "helpSubcommands", 1, UtilityMessages.INFO_CL_TOOL_DESCRIPTION_HELP_SUBCOMMANDS.get());
            this.helpSubcommandsArgument.addLongIdentifier("help-subcommands");
            this.helpSubcommandsArgument.setUsageArgument(true);
            parser.addArgument(this.helpSubcommandsArgument);
        }
        if ((version = this.getToolVersion()) != null && version.length() > 0 && parser.getNamedArgument("version") == null) {
            Character shortIdentifier = parser.getNamedArgument(Character.valueOf('V')) == null ? Character.valueOf('V') : null;
            this.versionArgument = new BooleanArgument(shortIdentifier, "version", UtilityMessages.INFO_CL_TOOL_DESCRIPTION_VERSION.get());
            this.versionArgument.setUsageArgument(true);
            parser.addArgument(this.versionArgument);
        }
        if (this.supportsPropertiesFile()) {
            parser.enablePropertiesFileSupport();
        }
        return parser;
    }

    void setHelpSASLArgument(BooleanArgument helpSASLArgument) {
        this.helpSASLArgument = helpSASLArgument;
    }

    static Set<String> getUsageArgumentIdentifiers(CommandLineTool tool) {
        LinkedHashSet<String> ids = new LinkedHashSet<String>(9);
        ids.add("help");
        ids.add("version");
        ids.add("helpSubcommands");
        if (tool.supportsInteractiveMode()) {
            ids.add("interactive");
        }
        if (tool.supportsPropertiesFile()) {
            ids.add("propertiesFilePath");
            ids.add("generatePropertiesFile");
            ids.add("noPropertiesFile");
        }
        if (tool.supportsOutputFile()) {
            ids.add("outputFile");
            ids.add("appendToOutputFile");
            ids.add("teeOutput");
        }
        return Collections.unmodifiableSet(ids);
    }

    public abstract void addToolArguments(ArgumentParser var1) throws ArgumentException;

    public void doExtendedArgumentValidation() throws ArgumentException {
    }

    public abstract ResultCode doToolProcessing();

    protected boolean registerShutdownHook() {
        return false;
    }

    protected void doShutdownHookProcessing(ResultCode resultCode) {
        throw new LDAPSDKUsageException(UtilityMessages.ERR_COMMAND_LINE_TOOL_SHUTDOWN_HOOK_NOT_IMPLEMENTED.get(this.getToolName()));
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public LinkedHashMap<String[], String> getExampleUsages() {
        return null;
    }

    public final PrintStream getOut() {
        return this.out;
    }

    public final PrintStream getOriginalOut() {
        return this.originalOut;
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final synchronized void out(Object ... msg) {
        CommandLineTool.write(this.out, 0, 0, msg);
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final synchronized void wrapOut(int indent, int wrapColumn, Object ... msg) {
        CommandLineTool.write(this.out, indent, wrapColumn, msg);
    }

    final synchronized void wrapStandardOut(int firstLineIndent, int subsequentLineIndent, int wrapColumn, boolean endWithNewline, Object ... msg) {
        CommandLineTool.write(this.out, firstLineIndent, subsequentLineIndent, wrapColumn, endWithNewline, msg);
    }

    public final PrintStream getErr() {
        return this.err;
    }

    public final PrintStream getOriginalErr() {
        return this.originalErr;
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final synchronized void err(Object ... msg) {
        CommandLineTool.write(this.err, 0, 0, msg);
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final synchronized void wrapErr(int indent, int wrapColumn, Object ... msg) {
        CommandLineTool.write(this.err, indent, wrapColumn, msg);
    }

    private static void write(PrintStream stream, int indent, int wrapColumn, Object ... msg) {
        CommandLineTool.write(stream, indent, indent, wrapColumn, true, msg);
    }

    private static void write(PrintStream stream, int firstLineIndent, int subsequentLineIndent, int wrapColumn, boolean endWithNewline, Object ... msg) {
        StringBuilder buffer = new StringBuilder();
        for (Object o : msg) {
            buffer.append(o);
        }
        if (wrapColumn > 2) {
            boolean firstLine = true;
            for (String line : StaticUtils.wrapLine(buffer.toString(), wrapColumn - firstLineIndent, wrapColumn - subsequentLineIndent)) {
                int indent;
                if (firstLine) {
                    indent = firstLineIndent;
                    firstLine = false;
                } else {
                    stream.println();
                    indent = subsequentLineIndent;
                }
                if (indent > 0) {
                    for (int i = 0; i < indent; ++i) {
                        stream.print(' ');
                    }
                }
                stream.print(line);
            }
        } else {
            if (firstLineIndent > 0) {
                for (int i = 0; i < firstLineIndent; ++i) {
                    stream.print(' ');
                }
            }
            stream.print(buffer.toString());
        }
        if (endWithNewline) {
            stream.println();
        }
        stream.flush();
    }
}

