/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.job;

import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.rollup.job.RollupJob;
import org.elasticsearch.xpack.rollup.Rollup;

public class RollupClientHelper {
    public static <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void executeAsync(Client client, RollupJob job, Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        Map<String, String> filteredHeaders = job.getHeaders().entrySet().stream().filter(e -> Rollup.HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ThreadContext threadContext = client.threadPool().getThreadContext();
        if (filteredHeaders.isEmpty()) {
            ClientHelper.executeAsyncWithOrigin((Client)client, (String)"rollup", action, request, listener);
        } else {
            Supplier supplier = threadContext.newRestorableContext(false);
            try (ThreadContext.StoredContext ignore = RollupClientHelper.stashWithHeaders(threadContext, filteredHeaders);){
                client.execute(action, request, (ActionListener)new ContextPreservingActionListener(supplier, listener));
            }
        }
    }

    private static ThreadContext.StoredContext stashWithHeaders(ThreadContext threadContext, Map<String, String> headers) {
        ThreadContext.StoredContext storedContext = threadContext.stashContext();
        threadContext.copyHeaders(headers.entrySet());
        return storedContext;
    }
}

