/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.plugin.CliFormatter;
import org.elasticsearch.xpack.sql.session.Configuration;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.RowSet;

public class CliFormatterCursor
implements Cursor {
    public static final String NAME = "f";
    private final Cursor delegate;
    private final CliFormatter formatter;

    public static Cursor wrap(Cursor newCursor, CliFormatter formatter) {
        if (newCursor == EMPTY) {
            return EMPTY;
        }
        return new CliFormatterCursor(newCursor, formatter);
    }

    private CliFormatterCursor(Cursor delegate, CliFormatter formatter) {
        this.delegate = delegate;
        this.formatter = formatter;
    }

    public CliFormatterCursor(StreamInput in) throws IOException {
        this.delegate = (Cursor)in.readNamedWriteable(Cursor.class);
        this.formatter = new CliFormatter(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.delegate);
        this.formatter.writeTo(out);
    }

    public CliFormatter getCliFormatter() {
        return this.formatter;
    }

    @Override
    public void nextPage(Configuration cfg, Client client, NamedWriteableRegistry registry, ActionListener<RowSet> listener) {
        this.delegate.nextPage(cfg, client, registry, listener);
    }

    @Override
    public void clear(Configuration cfg, Client client, ActionListener<Boolean> listener) {
        this.delegate.clear(cfg, client, listener);
    }

    public String getWriteableName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CliFormatterCursor that = (CliFormatterCursor)o;
        return Objects.equals(this.delegate, that.delegate) && Objects.equals(this.formatter, that.formatter);
    }

    public int hashCode() {
        return Objects.hash(this.delegate, this.formatter);
    }
}

