/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition;

import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.AggNameInput;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.AttributeInput;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.ConstantInput;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.ProcessorDefinition;

public abstract class ProcessorDefinitions {
    public static ProcessorDefinition toProcessorDefinition(Expression ex) {
        if (ex.foldable()) {
            return new ConstantInput(ex.location(), ex, ex.fold());
        }
        if (ex instanceof ScalarFunction) {
            return ((ScalarFunction)ex).asProcessorDefinition();
        }
        if (ex instanceof AggregateFunction) {
            return new AggNameInput(ex.location(), ex, ((AggregateFunction)ex).name());
        }
        if (ex instanceof NamedExpression) {
            return new AttributeInput(ex.location(), ex, ((NamedExpression)ex).toAttribute());
        }
        throw new SqlIllegalArgumentException("Cannot extract processor from {}", ex);
    }
}

