/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.crypto.Cipher;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.xpack.core.XPackClientActionPlugin;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.ssl.SSLClientAuth;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.core.ssl.VerificationMode;

public class XPackSettings {
    public static final Setting<Boolean> SECURITY_ENABLED = Setting.boolSetting((String)"xpack.security.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> MONITORING_ENABLED = Setting.boolSetting((String)"xpack.monitoring.enabled", s -> String.valueOf(!XPackClientActionPlugin.isTribeNode(s) && !XPackClientActionPlugin.isTribeClientNode(s)), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> WATCHER_ENABLED = Setting.boolSetting((String)"xpack.watcher.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> GRAPH_ENABLED = Setting.boolSetting((String)"xpack.graph.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> MACHINE_LEARNING_ENABLED = Setting.boolSetting((String)"xpack.ml.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> ROLLUP_ENABLED = Setting.boolSetting((String)"xpack.rollup.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> AUDIT_ENABLED = Setting.boolSetting((String)"xpack.security.audit.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> DLS_FLS_ENABLED = Setting.boolSetting((String)"xpack.security.dls_fls.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> LOGSTASH_ENABLED = Setting.boolSetting((String)"xpack.logstash.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> TRANSPORT_SSL_ENABLED = Setting.boolSetting((String)"xpack.security.transport.ssl.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> HTTP_SSL_ENABLED = Setting.boolSetting((String)"xpack.security.http.ssl.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> RESERVED_REALM_ENABLED_SETTING = Setting.boolSetting((String)"xpack.security.authc.reserved_realm.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> TOKEN_SERVICE_ENABLED_SETTING = Setting.boolSetting((String)"xpack.security.authc.token.enabled", s -> {
        if (((Boolean)NetworkModule.HTTP_ENABLED.get(s)).booleanValue()) {
            return HTTP_SSL_ENABLED.getRaw(s);
        }
        return Boolean.TRUE.toString();
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> SQL_ENABLED = Setting.boolSetting((String)"xpack.sql.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final List<String> DEFAULT_CIPHERS;
    public static final List<String> DEFAULT_SUPPORTED_PROTOCOLS;
    public static final SSLClientAuth CLIENT_AUTH_DEFAULT;
    public static final SSLClientAuth HTTP_CLIENT_AUTH_DEFAULT;
    public static final VerificationMode VERIFICATION_MODE_DEFAULT;
    public static final String GLOBAL_SSL_PREFIX = "xpack.ssl.";
    private static final SSLConfigurationSettings GLOBAL_SSL;
    public static final String HTTP_SSL_PREFIX;
    private static final SSLConfigurationSettings HTTP_SSL;
    public static final String TRANSPORT_SSL_PREFIX;
    private static final SSLConfigurationSettings TRANSPORT_SSL;

    public static List<Setting<?>> getAllSettings() {
        ArrayList settings = new ArrayList();
        settings.addAll(GLOBAL_SSL.getAllSettings());
        settings.addAll(HTTP_SSL.getAllSettings());
        settings.addAll(TRANSPORT_SSL.getAllSettings());
        settings.add(SECURITY_ENABLED);
        settings.add(MONITORING_ENABLED);
        settings.add(GRAPH_ENABLED);
        settings.add(MACHINE_LEARNING_ENABLED);
        settings.add(AUDIT_ENABLED);
        settings.add(WATCHER_ENABLED);
        settings.add(DLS_FLS_ENABLED);
        settings.add(LOGSTASH_ENABLED);
        settings.add(TRANSPORT_SSL_ENABLED);
        settings.add(HTTP_SSL_ENABLED);
        settings.add(RESERVED_REALM_ENABLED_SETTING);
        settings.add(TOKEN_SERVICE_ENABLED_SETTING);
        settings.add(SQL_ENABLED);
        settings.add(SecurityField.USER_SETTING);
        settings.add(ROLLUP_ENABLED);
        return Collections.unmodifiableList(settings);
    }

    static {
        List<String> ciphers = Arrays.asList("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA");
        try {
            boolean use256Bit;
            boolean bl = use256Bit = Cipher.getMaxAllowedKeyLength("AES") > 128;
            if (use256Bit) {
                ArrayList<String> strongerCiphers = new ArrayList<String>(ciphers.size() * 2);
                strongerCiphers.addAll(Arrays.asList("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA"));
                strongerCiphers.addAll(ciphers);
                ciphers = strongerCiphers;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        DEFAULT_CIPHERS = ciphers;
        DEFAULT_SUPPORTED_PROTOCOLS = Arrays.asList("TLSv1.2", "TLSv1.1", "TLSv1");
        CLIENT_AUTH_DEFAULT = SSLClientAuth.REQUIRED;
        HTTP_CLIENT_AUTH_DEFAULT = SSLClientAuth.NONE;
        VERIFICATION_MODE_DEFAULT = VerificationMode.FULL;
        GLOBAL_SSL = SSLConfigurationSettings.withPrefix(GLOBAL_SSL_PREFIX);
        HTTP_SSL_PREFIX = SecurityField.setting("http.ssl.");
        HTTP_SSL = SSLConfigurationSettings.withPrefix(HTTP_SSL_PREFIX);
        TRANSPORT_SSL_PREFIX = SecurityField.setting("transport.ssl.");
        TRANSPORT_SSL = SSLConfigurationSettings.withPrefix(TRANSPORT_SSL_PREFIX);
    }
}

