/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.time.Clock;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicensesMetaData;
import org.elasticsearch.license.PostStartBasicRequest;
import org.elasticsearch.license.PostStartBasicResponse;
import org.elasticsearch.license.SelfGeneratedLicense;
import org.elasticsearch.xpack.core.XPackPlugin;

public class StartBasicClusterTask
extends ClusterStateUpdateTask {
    private static final String ACKNOWLEDGEMENT_HEADER = "This license update requires acknowledgement. To acknowledge the license, please read the following messages and call /start_basic again, this time with the \"acknowledge=true\" parameter:";
    private final Logger logger;
    private final String clusterName;
    private final PostStartBasicRequest request;
    private final ActionListener<PostStartBasicResponse> listener;
    private final Clock clock;
    private AtomicReference<Map<String, String[]>> ackMessages = new AtomicReference(Collections.emptyMap());

    StartBasicClusterTask(Logger logger, String clusterName, Clock clock, PostStartBasicRequest request, ActionListener<PostStartBasicResponse> listener) {
        this.logger = logger;
        this.clusterName = clusterName;
        this.request = request;
        this.listener = listener;
        this.clock = clock;
    }

    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
        LicensesMetaData oldLicensesMetaData = (LicensesMetaData)oldState.metaData().custom("licenses");
        this.logger.debug("license prior to starting basic license: {}", (Object)oldLicensesMetaData);
        License oldLicense = LicensesMetaData.extractLicense(oldLicensesMetaData);
        Map<String, String[]> acknowledgeMessages = this.ackMessages.get();
        if (!acknowledgeMessages.isEmpty()) {
            this.listener.onResponse((Object)new PostStartBasicResponse(PostStartBasicResponse.Status.NEED_ACKNOWLEDGEMENT, acknowledgeMessages, ACKNOWLEDGEMENT_HEADER));
        } else if (oldLicense != null && oldLicense.type().equals("basic")) {
            this.listener.onResponse((Object)new PostStartBasicResponse(PostStartBasicResponse.Status.ALREADY_USING_BASIC));
        } else {
            this.listener.onResponse((Object)new PostStartBasicResponse(PostStartBasicResponse.Status.GENERATED_BASIC));
        }
    }

    public ClusterState execute(ClusterState currentState) throws Exception {
        XPackPlugin.checkReadyForXPackCustomMetadata(currentState);
        LicensesMetaData licensesMetaData = (LicensesMetaData)currentState.metaData().custom("licenses");
        License currentLicense = LicensesMetaData.extractLicense(licensesMetaData);
        if (currentLicense == null || !currentLicense.type().equals("basic")) {
            Map<String, String[]> ackMessages;
            long issueDate = this.clock.millis();
            MetaData.Builder mdBuilder = MetaData.builder((MetaData)currentState.metaData());
            License.Builder specBuilder = License.builder().uid(UUID.randomUUID().toString()).issuedTo(this.clusterName).maxNodes(1000).issueDate(issueDate).type("basic").expiryDate(LicenseService.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS);
            License selfGeneratedLicense = SelfGeneratedLicense.create(specBuilder);
            if (!this.request.isAcknowledged() && currentLicense != null && !(ackMessages = LicenseService.getAckMessages(selfGeneratedLicense, currentLicense)).isEmpty()) {
                this.ackMessages.set(ackMessages);
                return currentState;
            }
            Version trialVersion = null;
            if (licensesMetaData != null) {
                trialVersion = licensesMetaData.getMostRecentTrialVersion();
            }
            LicensesMetaData newLicensesMetaData = new LicensesMetaData(selfGeneratedLicense, trialVersion);
            mdBuilder.putCustom("licenses", (MetaData.Custom)newLicensesMetaData);
            return ClusterState.builder((ClusterState)currentState).metaData(mdBuilder).build();
        }
        return currentState;
    }

    public void onFailure(String source, @Nullable Exception e) {
        this.logger.error((Message)new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
        this.listener.onFailure(e);
    }
}

