/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.movavg.models;

import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.pipeline.movavg.MovAvgPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModelBuilder;

public class EwmaModel
extends MovAvgModel {
    public static final String NAME = "ewma";
    public static final double DEFAULT_ALPHA = 0.3;
    private final double alpha;
    public static final MovAvgModel.AbstractModelParser PARSER = new MovAvgModel.AbstractModelParser(){

        @Override
        public MovAvgModel parse(@Nullable Map<String, Object> settings, String pipelineName, int windowSize) throws ParseException {
            double alpha = this.parseDoubleParam(settings, "alpha", 0.3);
            this.checkUnrecognizedParams(settings);
            return new EwmaModel(alpha);
        }
    };

    public EwmaModel() {
        this(0.3);
    }

    public EwmaModel(double alpha) {
        this.alpha = alpha;
    }

    public EwmaModel(StreamInput in) throws IOException {
        this.alpha = in.readDouble();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.alpha);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public boolean canBeMinimized() {
        return true;
    }

    @Override
    public MovAvgModel neighboringModel() {
        double alpha = Math.random();
        return new EwmaModel(alpha);
    }

    @Override
    public MovAvgModel clone() {
        return new EwmaModel(this.alpha);
    }

    @Override
    protected <T extends Number> double[] doPredict(Collection<T> values, int numPredictions) {
        double[] predictions = new double[numPredictions];
        Arrays.fill(predictions, this.next(values));
        return predictions;
    }

    @Override
    public <T extends Number> double next(Collection<T> values) {
        double avg = 0.0;
        boolean first = true;
        for (Number v : values) {
            if (first) {
                avg = v.doubleValue();
                first = false;
                continue;
            }
            avg = v.doubleValue() * this.alpha + avg * (1.0 - this.alpha);
        }
        return avg;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(MovAvgPipelineAggregationBuilder.MODEL.getPreferredName(), NAME);
        builder.startObject(MovAvgPipelineAggregationBuilder.SETTINGS.getPreferredName());
        builder.field("alpha", this.alpha);
        builder.endObject();
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.alpha);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EwmaModel other = (EwmaModel)obj;
        return Objects.equals(this.alpha, other.alpha);
    }

    public static class EWMAModelBuilder
    implements MovAvgModelBuilder {
        private double alpha = 0.3;

        public EWMAModelBuilder alpha(double alpha) {
            this.alpha = alpha;
            return this;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(MovAvgPipelineAggregationBuilder.MODEL.getPreferredName(), EwmaModel.NAME);
            builder.startObject(MovAvgPipelineAggregationBuilder.SETTINGS.getPreferredName());
            builder.field("alpha", this.alpha);
            builder.endObject();
            return builder;
        }

        @Override
        public MovAvgModel build() {
            return new EwmaModel(this.alpha);
        }
    }
}

