/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SearchResultEntry
extends ReadOnlyEntry
implements LDAPResponse {
    private static final long serialVersionUID = -290721544252526163L;
    private final Control[] controls;
    private final int messageID;

    public SearchResultEntry(String dn, Attribute[] attributes, Control ... controls) {
        this(-1, dn, null, attributes, controls);
    }

    public SearchResultEntry(int messageID, String dn, Attribute[] attributes, Control ... controls) {
        this(messageID, dn, null, attributes, controls);
    }

    public SearchResultEntry(int messageID, String dn, Schema schema, Attribute[] attributes, Control ... controls) {
        super(dn, schema, attributes);
        Validator.ensureNotNull(controls);
        this.messageID = messageID;
        this.controls = controls;
    }

    public SearchResultEntry(String dn, Collection<Attribute> attributes, Control ... controls) {
        this(-1, dn, null, attributes, controls);
    }

    public SearchResultEntry(int messageID, String dn, Collection<Attribute> attributes, Control ... controls) {
        this(messageID, dn, null, attributes, controls);
    }

    public SearchResultEntry(int messageID, String dn, Schema schema, Collection<Attribute> attributes, Control ... controls) {
        super(dn, schema, attributes);
        Validator.ensureNotNull(controls);
        this.messageID = messageID;
        this.controls = controls;
    }

    public SearchResultEntry(Entry entry, Control ... controls) {
        this(-1, entry, controls);
    }

    public SearchResultEntry(int messageID, Entry entry, Control ... controls) {
        super(entry);
        Validator.ensureNotNull(controls);
        this.messageID = messageID;
        this.controls = controls;
    }

    static SearchResultEntry readSearchEntryFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader, Schema schema) throws LDAPException {
        try {
            reader.beginSequence();
            String dn = reader.readString();
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(10);
            ASN1StreamReaderSequence attrSequence = reader.beginSequence();
            while (attrSequence.hasMoreElements()) {
                attrList.add(Attribute.readFrom(reader, schema));
            }
            Control[] controls = NO_CONTROLS;
            if (messageSequence.hasMoreElements()) {
                ArrayList<Control> controlList = new ArrayList<Control>(5);
                ASN1StreamReaderSequence controlSequence = reader.beginSequence();
                while (controlSequence.hasMoreElements()) {
                    controlList.add(Control.readFrom(reader));
                }
                controls = new Control[controlList.size()];
                controlList.toArray(controls);
            }
            return new SearchResultEntry(messageID, dn, schema, attrList, controls);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_SEARCH_ENTRY_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public int getMessageID() {
        return this.messageID;
    }

    public Control[] getControls() {
        return this.controls;
    }

    public Control getControl(String oid) {
        for (Control c : this.controls) {
            if (!c.getOID().equals(oid)) continue;
            return c;
        }
        return null;
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        for (Control c : this.controls) {
            hashCode += c.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SearchResultEntry)) {
            return false;
        }
        SearchResultEntry e = (SearchResultEntry)o;
        if (this.controls.length != e.controls.length) {
            return false;
        }
        for (int i = 0; i < this.controls.length; ++i) {
            if (this.controls[i].equals(e.controls[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("SearchResultEntry(dn='");
        buffer.append(this.getDN());
        buffer.append('\'');
        if (this.messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(this.messageID);
        }
        buffer.append(", attributes={");
        Iterator<Attribute> iterator = this.getAttributes().iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, controls={");
        for (int i = 0; i < this.controls.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.controls[i].toString(buffer);
        }
        buffer.append("})");
    }
}

