/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.normalizer;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.xpack.ml.job.process.normalizer.Normalizable;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerProcess;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerProcessFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerResult;
import org.elasticsearch.xpack.ml.job.process.normalizer.output.NormalizerResultHandler;

public class Normalizer {
    private static final Logger LOGGER = Loggers.getLogger(Normalizer.class);
    private final String jobId;
    private final NormalizerProcessFactory processFactory;
    private final ExecutorService executorService;

    public Normalizer(String jobId, NormalizerProcessFactory processFactory, ExecutorService executorService) {
        this.jobId = jobId;
        this.processFactory = processFactory;
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void normalize(Integer bucketSpan, boolean perPartitionNormalization, List<? extends Normalizable> results, String quantilesState) {
        NormalizerProcess process = this.processFactory.createNormalizerProcess(this.jobId, quantilesState, bucketSpan, perPartitionNormalization, this.executorService);
        NormalizerResultHandler resultsHandler = process.createNormalizedResultsHandler();
        Future<?> resultsHandlerFuture = this.executorService.submit(() -> {
            try {
                resultsHandler.process();
            }
            catch (IOException e) {
                LOGGER.error((Message)new ParameterizedMessage("[{}] Error reading normalizer results", new Object[]{this.jobId}), (Throwable)e);
            }
        });
        try {
            process.writeRecord(new String[]{NormalizerResult.LEVEL_FIELD.getPreferredName(), NormalizerResult.PARTITION_FIELD_NAME_FIELD.getPreferredName(), NormalizerResult.PARTITION_FIELD_VALUE_FIELD.getPreferredName(), NormalizerResult.PERSON_FIELD_NAME_FIELD.getPreferredName(), NormalizerResult.FUNCTION_NAME_FIELD.getPreferredName(), NormalizerResult.VALUE_FIELD_NAME_FIELD.getPreferredName(), NormalizerResult.PROBABILITY_FIELD.getPreferredName(), NormalizerResult.NORMALIZED_SCORE_FIELD.getPreferredName()});
            for (Normalizable normalizable : results) {
                Normalizer.writeNormalizableAndChildrenRecursively(normalizable, process);
            }
        }
        catch (IOException e) {
            LOGGER.error("[" + this.jobId + "] Error writing to the normalizer", (Throwable)e);
        }
        finally {
            try {
                process.close();
            }
            catch (IOException e) {
                LOGGER.error("[" + this.jobId + "] Error closing normalizer", (Throwable)e);
            }
        }
        try {
            resultsHandlerFuture.get();
            this.mergeNormalizedScoresIntoResults(resultsHandler.getNormalizedResults(), results);
        }
        catch (ExecutionException e) {
            LOGGER.error((Message)new ParameterizedMessage("[{}] Error processing normalizer results", new Object[]{this.jobId}), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static void writeNormalizableAndChildrenRecursively(Normalizable normalizable, NormalizerProcess process) throws IOException {
        if (!normalizable.isContainerOnly()) {
            process.writeRecord(new String[]{normalizable.getLevel().asString(), Strings.coalesceToEmpty((String)normalizable.getPartitionFieldName()), Strings.coalesceToEmpty((String)normalizable.getPartitionFieldValue()), Strings.coalesceToEmpty((String)normalizable.getPersonFieldName()), Strings.coalesceToEmpty((String)normalizable.getFunctionName()), Strings.coalesceToEmpty((String)normalizable.getValueFieldName()), Double.toString(normalizable.getProbability()), Double.toString(normalizable.getNormalizedScore())});
        }
        for (Normalizable child : normalizable.getChildren()) {
            Normalizer.writeNormalizableAndChildrenRecursively(child, process);
        }
    }

    private void mergeNormalizedScoresIntoResults(List<NormalizerResult> normalizedScores, List<? extends Normalizable> results) {
        Iterator<NormalizerResult> scoresIter = normalizedScores.iterator();
        for (Normalizable normalizable : results) {
            this.mergeRecursively(scoresIter, null, false, normalizable);
        }
        if (scoresIter.hasNext()) {
            LOGGER.error("[{}] Unused normalized scores remain after updating all results: {} for {}", (Object)this.jobId, (Object)normalizedScores.size(), (Object)results.size());
        }
    }

    private double mergeRecursively(Iterator<NormalizerResult> scoresIter, Normalizable parent, boolean parentHadBigChange, Normalizable result) {
        boolean hasBigChange = false;
        if (!result.isContainerOnly()) {
            if (!scoresIter.hasNext()) {
                String msg = "Error iterating normalized results";
                LOGGER.error("[{}] {}", (Object)this.jobId, (Object)msg);
                throw new ElasticsearchException(msg, new Object[0]);
            }
            result.resetBigChangeFlag();
            if (parent != null && parentHadBigChange) {
                result.setParentScore(parent.getNormalizedScore());
                result.raiseBigChangeFlag();
            }
            double normalizedScore = scoresIter.next().getNormalizedScore();
            hasBigChange = Normalizer.isBigUpdate(result.getNormalizedScore(), normalizedScore);
            if (hasBigChange) {
                result.setNormalizedScore(normalizedScore);
                result.raiseBigChangeFlag();
                if (parent != null) {
                    parent.raiseBigChangeFlag();
                }
            }
        }
        for (Normalizable.ChildType childrenType : result.getChildrenTypes()) {
            List<Normalizable> children = result.getChildren(childrenType);
            if (children.isEmpty()) continue;
            double maxChildrenScore = 0.0;
            for (Normalizable child : children) {
                maxChildrenScore = Math.max(this.mergeRecursively(scoresIter, result, hasBigChange, child), maxChildrenScore);
            }
            hasBigChange |= result.setMaxChildrenScore(childrenType, maxChildrenScore);
        }
        return result.getNormalizedScore();
    }

    private static boolean isBigUpdate(double oldVal, double newVal) {
        if (Math.abs(oldVal - newVal) >= 1.0) {
            return true;
        }
        return oldVal > newVal ? oldVal * 0.5 > newVal : newVal * 0.5 > oldVal;
    }
}

