/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io;

public class ByteOrderValues {
    public static final int BIG_ENDIAN = 1;
    public static final int LITTLE_ENDIAN = 2;

    public static int getInt(byte[] buf, int byteOrder) {
        if (byteOrder == 1) {
            return (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
        }
        return (buf[3] & 0xFF) << 24 | (buf[2] & 0xFF) << 16 | (buf[1] & 0xFF) << 8 | buf[0] & 0xFF;
    }

    public static void putInt(int intValue, byte[] buf, int byteOrder) {
        if (byteOrder == 1) {
            buf[0] = (byte)(intValue >> 24);
            buf[1] = (byte)(intValue >> 16);
            buf[2] = (byte)(intValue >> 8);
            buf[3] = (byte)intValue;
        } else {
            buf[0] = (byte)intValue;
            buf[1] = (byte)(intValue >> 8);
            buf[2] = (byte)(intValue >> 16);
            buf[3] = (byte)(intValue >> 24);
        }
    }

    public static long getLong(byte[] buf, int byteOrder) {
        if (byteOrder == 1) {
            return (long)(buf[0] & 0xFF) << 56 | (long)(buf[1] & 0xFF) << 48 | (long)(buf[2] & 0xFF) << 40 | (long)(buf[3] & 0xFF) << 32 | (long)(buf[4] & 0xFF) << 24 | (long)(buf[5] & 0xFF) << 16 | (long)(buf[6] & 0xFF) << 8 | (long)(buf[7] & 0xFF);
        }
        return (long)(buf[7] & 0xFF) << 56 | (long)(buf[6] & 0xFF) << 48 | (long)(buf[5] & 0xFF) << 40 | (long)(buf[4] & 0xFF) << 32 | (long)(buf[3] & 0xFF) << 24 | (long)(buf[2] & 0xFF) << 16 | (long)(buf[1] & 0xFF) << 8 | (long)(buf[0] & 0xFF);
    }

    public static void putLong(long longValue, byte[] buf, int byteOrder) {
        if (byteOrder == 1) {
            buf[0] = (byte)(longValue >> 56);
            buf[1] = (byte)(longValue >> 48);
            buf[2] = (byte)(longValue >> 40);
            buf[3] = (byte)(longValue >> 32);
            buf[4] = (byte)(longValue >> 24);
            buf[5] = (byte)(longValue >> 16);
            buf[6] = (byte)(longValue >> 8);
            buf[7] = (byte)longValue;
        } else {
            buf[0] = (byte)longValue;
            buf[1] = (byte)(longValue >> 8);
            buf[2] = (byte)(longValue >> 16);
            buf[3] = (byte)(longValue >> 24);
            buf[4] = (byte)(longValue >> 32);
            buf[5] = (byte)(longValue >> 40);
            buf[6] = (byte)(longValue >> 48);
            buf[7] = (byte)(longValue >> 56);
        }
    }

    public static double getDouble(byte[] buf, int byteOrder) {
        long longVal = ByteOrderValues.getLong(buf, byteOrder);
        return Double.longBitsToDouble(longVal);
    }

    public static void putDouble(double doubleValue, byte[] buf, int byteOrder) {
        long longVal = Double.doubleToLongBits(doubleValue);
        ByteOrderValues.putLong(longVal, buf, byteOrder);
    }
}

