/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Counter;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.AbstractRefCounted;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.search.SearchExtBuilder;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.SearchContextAggregations;
import org.elasticsearch.search.collapse.CollapseContext;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.DocValueFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.profile.Profilers;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.suggest.SuggestionSearchContext;

public abstract class SearchContext
extends AbstractRefCounted
implements Releasable {
    public static final int DEFAULT_TERMINATE_AFTER = 0;
    private Map<Lifetime, List<Releasable>> clearables = null;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private InnerHitsContext innerHitsContext;

    protected SearchContext() {
        super("search_context");
    }

    public abstract void setTask(SearchTask var1);

    public abstract SearchTask getTask();

    public abstract boolean isCancelled();

    @Override
    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.decRef();
        }
    }

    @Override
    protected final void closeInternal() {
        try {
            this.clearReleasables(Lifetime.CONTEXT);
        }
        finally {
            this.doClose();
        }
    }

    @Override
    protected void alreadyClosed() {
        throw new IllegalStateException("search context is already closed can't increment refCount current count [" + this.refCount() + "]");
    }

    protected abstract void doClose();

    public abstract void preProcess(boolean var1);

    public abstract Query buildFilteredQuery(Query var1);

    public abstract long id();

    public abstract String source();

    public abstract ShardSearchRequest request();

    public abstract SearchType searchType();

    public abstract SearchShardTarget shardTarget();

    public abstract int numberOfShards();

    public abstract float queryBoost();

    public abstract long getOriginNanoTime();

    public abstract ScrollContext scrollContext();

    public abstract SearchContext scrollContext(ScrollContext var1);

    public abstract SearchContextAggregations aggregations();

    public abstract SearchContext aggregations(SearchContextAggregations var1);

    public abstract void addSearchExt(SearchExtBuilder var1);

    public abstract SearchExtBuilder getSearchExt(String var1);

    public abstract SearchContextHighlight highlight();

    public abstract void highlight(SearchContextHighlight var1);

    public InnerHitsContext innerHits() {
        if (this.innerHitsContext == null) {
            this.innerHitsContext = new InnerHitsContext();
        }
        return this.innerHitsContext;
    }

    public abstract SuggestionSearchContext suggest();

    public abstract void suggest(SuggestionSearchContext var1);

    public abstract List<RescoreSearchContext> rescore();

    public abstract void addRescore(RescoreSearchContext var1);

    public abstract boolean hasScriptFields();

    public abstract ScriptFieldsContext scriptFields();

    public abstract boolean sourceRequested();

    public abstract boolean hasFetchSourceContext();

    public abstract FetchSourceContext fetchSourceContext();

    public abstract SearchContext fetchSourceContext(FetchSourceContext var1);

    public abstract DocValueFieldsContext docValueFieldsContext();

    public abstract SearchContext docValueFieldsContext(DocValueFieldsContext var1);

    public abstract ContextIndexSearcher searcher();

    public abstract IndexShard indexShard();

    public abstract MapperService mapperService();

    public abstract SimilarityService similarityService();

    public abstract BigArrays bigArrays();

    public abstract BitsetFilterCache bitsetFilterCache();

    public abstract IndexFieldDataService fieldData();

    public abstract TimeValue timeout();

    public abstract void timeout(TimeValue var1);

    public abstract int terminateAfter();

    public abstract void terminateAfter(int var1);

    public abstract boolean lowLevelCancellation();

    public abstract SearchContext minimumScore(float var1);

    public abstract Float minimumScore();

    public abstract SearchContext sort(SortAndFormats var1);

    public abstract SortAndFormats sort();

    public abstract SearchContext trackScores(boolean var1);

    public abstract boolean trackScores();

    public abstract SearchContext searchAfter(FieldDoc var1);

    public abstract FieldDoc searchAfter();

    public abstract SearchContext collapse(CollapseContext var1);

    public abstract CollapseContext collapse();

    public abstract SearchContext parsedPostFilter(ParsedQuery var1);

    public abstract ParsedQuery parsedPostFilter();

    public abstract Query aliasFilter();

    public abstract SearchContext parsedQuery(ParsedQuery var1);

    public abstract ParsedQuery parsedQuery();

    public abstract Query query();

    public abstract int from();

    public abstract SearchContext from(int var1);

    public abstract int size();

    public abstract SearchContext size(int var1);

    public abstract boolean hasStoredFields();

    public abstract boolean hasStoredFieldsContext();

    public abstract boolean storedFieldsRequested();

    public abstract StoredFieldsContext storedFieldsContext();

    public abstract SearchContext storedFieldsContext(StoredFieldsContext var1);

    public abstract boolean explain();

    public abstract void explain(boolean var1);

    @Nullable
    public abstract List<String> groupStats();

    public abstract void groupStats(List<String> var1);

    public abstract boolean version();

    public abstract void version(boolean var1);

    public abstract int[] docIdsToLoad();

    public abstract int docIdsToLoadFrom();

    public abstract int docIdsToLoadSize();

    public abstract SearchContext docIdsToLoad(int[] var1, int var2, int var3);

    public abstract void accessed(long var1);

    public abstract long lastAccessTime();

    public abstract long keepAlive();

    public abstract void keepAlive(long var1);

    public SearchLookup lookup() {
        return this.getQueryShardContext().lookup();
    }

    public abstract DfsSearchResult dfsResult();

    public abstract QuerySearchResult queryResult();

    public abstract FetchPhase fetchPhase();

    public abstract FetchSearchResult fetchResult();

    public abstract Profilers getProfilers();

    public void addReleasable(Releasable releasable, Lifetime lifetime) {
        List<Releasable> releasables;
        if (this.clearables == null) {
            this.clearables = new EnumMap<Lifetime, List<Releasable>>(Lifetime.class);
        }
        if ((releasables = this.clearables.get((Object)lifetime)) == null) {
            releasables = new ArrayList<Releasable>();
            this.clearables.put(lifetime, releasables);
        }
        releasables.add(releasable);
    }

    public void clearReleasables(Lifetime lifetime) {
        if (this.clearables != null) {
            ArrayList<List<Releasable>> releasables = new ArrayList<List<Releasable>>();
            for (Lifetime lc : Lifetime.values()) {
                if (lc.compareTo(lifetime) > 0) break;
                List<Releasable> remove = this.clearables.remove((Object)lc);
                if (remove == null) continue;
                releasables.add(remove);
            }
            Releasables.close(Iterables.flatten(releasables));
        }
    }

    public final boolean hasOnlySuggest() {
        return this.request().source() != null && this.request().source().isSuggestOnly();
    }

    public abstract MappedFieldType smartNameFieldType(String var1);

    public abstract ObjectMapper getObjectMapper(String var1);

    public abstract Counter timeEstimateCounter();

    public abstract Map<Class<?>, Collector> queryCollectors();

    public abstract QueryShardContext getQueryShardContext();

    public String toString() {
        StringBuilder result = new StringBuilder().append(this.shardTarget());
        if (this.searchType() != SearchType.DEFAULT) {
            result.append("searchType=[").append((Object)this.searchType()).append("]");
        }
        if (this.scrollContext() != null) {
            if (this.scrollContext().scroll != null) {
                result.append("scroll=[").append(this.scrollContext().scroll.keepAlive()).append("]");
            } else {
                result.append("scroll=[null]");
            }
        }
        result.append(" query=[").append(this.query()).append("]");
        return result.toString();
    }

    public static enum Lifetime {
        COLLECTION,
        PHASE,
        CONTEXT;

    }
}

