/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingService;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.FailedShard;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.gateway.PrimaryShardAllocator;
import org.elasticsearch.gateway.PriorityComparator;
import org.elasticsearch.gateway.ReplicaShardAllocator;
import org.elasticsearch.gateway.TransportNodesListGatewayStartedShards;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetaData;

public class GatewayAllocator
extends AbstractComponent {
    private RoutingService routingService;
    private final PrimaryShardAllocator primaryShardAllocator;
    private final ReplicaShardAllocator replicaShardAllocator;
    private final ConcurrentMap<ShardId, AsyncShardFetch<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>> asyncFetchStarted = ConcurrentCollections.newConcurrentMap();
    private final ConcurrentMap<ShardId, AsyncShardFetch<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData>> asyncFetchStore = ConcurrentCollections.newConcurrentMap();

    @Inject
    public GatewayAllocator(Settings settings, TransportNodesListGatewayStartedShards startedAction, TransportNodesListShardStoreMetaData storeAction) {
        super(settings);
        this.primaryShardAllocator = new InternalPrimaryShardAllocator(settings, startedAction);
        this.replicaShardAllocator = new InternalReplicaShardAllocator(settings, storeAction);
    }

    public void setReallocation(ClusterService clusterService, RoutingService routingService) {
        this.routingService = routingService;
        clusterService.addStateApplier(event -> {
            boolean cleanCache = false;
            DiscoveryNode localNode = event.state().nodes().getLocalNode();
            if (localNode != null) {
                if (localNode.isMasterNode() && !event.localNodeMaster()) {
                    cleanCache = true;
                }
            } else {
                cleanCache = true;
            }
            if (cleanCache) {
                Releasables.close(this.asyncFetchStarted.values());
                this.asyncFetchStarted.clear();
                Releasables.close(this.asyncFetchStore.values());
                this.asyncFetchStore.clear();
            }
        });
    }

    public int getNumberOfInFlightFetch() {
        int count = 0;
        for (AsyncShardFetch fetch : this.asyncFetchStarted.values()) {
            count += fetch.getNumberOfInFlightFetches();
        }
        for (AsyncShardFetch fetch : this.asyncFetchStore.values()) {
            count += fetch.getNumberOfInFlightFetches();
        }
        return count;
    }

    public void applyStartedShards(RoutingAllocation allocation, List<ShardRouting> startedShards) {
        for (ShardRouting startedShard : startedShards) {
            Releasables.close((Releasable)this.asyncFetchStarted.remove(startedShard.shardId()));
            Releasables.close((Releasable)this.asyncFetchStore.remove(startedShard.shardId()));
        }
    }

    public void applyFailedShards(RoutingAllocation allocation, List<FailedShard> failedShards) {
        for (FailedShard failedShard : failedShards) {
            Releasables.close((Releasable)this.asyncFetchStarted.remove(failedShard.getRoutingEntry().shardId()));
            Releasables.close((Releasable)this.asyncFetchStore.remove(failedShard.getRoutingEntry().shardId()));
        }
    }

    public void allocateUnassigned(RoutingAllocation allocation) {
        GatewayAllocator.innerAllocatedUnassigned(allocation, this.primaryShardAllocator, this.replicaShardAllocator);
    }

    protected static void innerAllocatedUnassigned(RoutingAllocation allocation, PrimaryShardAllocator primaryShardAllocator, ReplicaShardAllocator replicaShardAllocator) {
        RoutingNodes.UnassignedShards unassigned = allocation.routingNodes().unassigned();
        unassigned.sort(PriorityComparator.getAllocationComparator(allocation));
        primaryShardAllocator.allocateUnassigned(allocation);
        replicaShardAllocator.processExistingRecoveries(allocation);
        replicaShardAllocator.allocateUnassigned(allocation);
    }

    public AllocateUnassignedDecision decideUnassignedShardAllocation(ShardRouting unassignedShard, RoutingAllocation routingAllocation) {
        if (unassignedShard.primary()) {
            return this.primaryShardAllocator.makeAllocationDecision(unassignedShard, routingAllocation, this.logger);
        }
        return this.replicaShardAllocator.makeAllocationDecision(unassignedShard, routingAllocation, this.logger);
    }

    class InternalReplicaShardAllocator
    extends ReplicaShardAllocator {
        private final TransportNodesListShardStoreMetaData storeAction;

        InternalReplicaShardAllocator(Settings settings, TransportNodesListShardStoreMetaData storeAction) {
            super(settings);
            this.storeAction = storeAction;
        }

        @Override
        protected AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> fetchData(ShardRouting shard, RoutingAllocation allocation) {
            AsyncShardFetch fetch = GatewayAllocator.this.asyncFetchStore.computeIfAbsent(shard.shardId(), shardId -> new InternalAsyncFetch<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData>(this.logger, "shard_store", shard.shardId(), this.storeAction));
            AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> shardStores = fetch.fetchData(allocation.nodes(), allocation.getIgnoreNodes(shard.shardId()));
            if (shardStores.hasData()) {
                shardStores.processAllocation(allocation);
            }
            return shardStores;
        }

        @Override
        protected boolean hasInitiatedFetching(ShardRouting shard) {
            return GatewayAllocator.this.asyncFetchStore.get(shard.shardId()) != null;
        }
    }

    class InternalPrimaryShardAllocator
    extends PrimaryShardAllocator {
        private final TransportNodesListGatewayStartedShards startedAction;

        InternalPrimaryShardAllocator(Settings settings, TransportNodesListGatewayStartedShards startedAction) {
            super(settings);
            this.startedAction = startedAction;
        }

        @Override
        protected AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> fetchData(ShardRouting shard, RoutingAllocation allocation) {
            AsyncShardFetch fetch = GatewayAllocator.this.asyncFetchStarted.computeIfAbsent(shard.shardId(), shardId -> new InternalAsyncFetch<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>(this.logger, "shard_started", (ShardId)shardId, this.startedAction));
            AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> shardState = fetch.fetchData(allocation.nodes(), allocation.getIgnoreNodes(shard.shardId()));
            if (shardState.hasData()) {
                shardState.processAllocation(allocation);
            }
            return shardState;
        }
    }

    class InternalAsyncFetch<T extends BaseNodeResponse>
    extends AsyncShardFetch<T> {
        InternalAsyncFetch(Logger logger, String type, ShardId shardId, AsyncShardFetch.Lister<? extends BaseNodesResponse<T>, T> action) {
            super(logger, type, shardId, action);
        }

        @Override
        protected void reroute(ShardId shardId, String reason) {
            this.logger.trace("{} scheduling reroute for {}", (Object)shardId, (Object)reason);
            GatewayAllocator.this.routingService.reroute("async_shard_fetch");
        }
    }
}

