/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.GeneralScriptException;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.expression.ReplaceableConstDoubleValueSource;

class ExpressionSearchScript
implements SearchScript {
    final CompiledScript compiledScript;
    final SimpleBindings bindings;
    final DoubleValuesSource source;
    final ReplaceableConstDoubleValueSource specialValue;
    final boolean needsScores;
    Scorer scorer;
    int docid;

    ExpressionSearchScript(CompiledScript c, SimpleBindings b, ReplaceableConstDoubleValueSource v, boolean needsScores) {
        this.compiledScript = c;
        this.bindings = b;
        this.source = ((Expression)this.compiledScript.compiled()).getDoubleValuesSource((Bindings)this.bindings);
        this.specialValue = v;
        this.needsScores = needsScores;
    }

    public boolean needsScores() {
        return this.needsScores;
    }

    public LeafSearchScript getLeafSearchScript(final LeafReaderContext leaf) throws IOException {
        return new LeafSearchScript(){
            DoubleValues values;
            {
                this.values = ExpressionSearchScript.this.source.getValues(leaf, new DoubleValues(){

                    public double doubleValue() throws IOException {
                        return Double.NaN;
                    }

                    public boolean advanceExact(int doc) throws IOException {
                        return true;
                    }
                });
            }

            double evaluate() {
                try {
                    return this.values.doubleValue();
                }
                catch (Exception exception) {
                    throw new GeneralScriptException("Error evaluating " + ExpressionSearchScript.this.compiledScript, (Throwable)exception);
                }
            }

            public Object run() {
                return this.evaluate();
            }

            public long runAsLong() {
                return (long)this.evaluate();
            }

            public double runAsDouble() {
                return this.evaluate();
            }

            public void setDocument(int d) {
                ExpressionSearchScript.this.docid = d;
                try {
                    this.values.advanceExact(d);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't advance to doc using " + ExpressionSearchScript.this.compiledScript, e);
                }
            }

            public void setScorer(Scorer s) {
                ExpressionSearchScript.this.scorer = s;
                try {
                    this.values = ExpressionSearchScript.this.source.getValues(leaf, new DoubleValues(){

                        public double doubleValue() throws IOException {
                            return ExpressionSearchScript.this.scorer.score();
                        }

                        public boolean advanceExact(int doc) throws IOException {
                            return true;
                        }
                    });
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't get values using " + ExpressionSearchScript.this.compiledScript, e);
                }
            }

            public void setSource(Map<String, Object> source) {
            }

            public void setNextAggregationValue(Object value) {
                if (ExpressionSearchScript.this.specialValue != null) {
                    if (value instanceof Number) {
                        ExpressionSearchScript.this.specialValue.setValue(((Number)value).doubleValue());
                    } else {
                        throw new GeneralScriptException("Cannot use expression with text variable using " + ExpressionSearchScript.this.compiledScript);
                    }
                }
            }

            public void setNextVar(String name, Object value) {
            }
        };
    }
}

