/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.queryparser.xml.QueryBuilder;
import org.apache.lucene.queryparser.xml.QueryBuilderFactory;
import org.apache.lucene.queryparser.xml.builders.BooleanQueryBuilder;
import org.apache.lucene.queryparser.xml.builders.BoostingTermBuilder;
import org.apache.lucene.queryparser.xml.builders.ConstantScoreQueryBuilder;
import org.apache.lucene.queryparser.xml.builders.DisjunctionMaxQueryBuilder;
import org.apache.lucene.queryparser.xml.builders.LegacyNumericRangeQueryBuilder;
import org.apache.lucene.queryparser.xml.builders.MatchAllDocsQueryBuilder;
import org.apache.lucene.queryparser.xml.builders.PointRangeQueryBuilder;
import org.apache.lucene.queryparser.xml.builders.RangeQueryBuilder;
import org.apache.lucene.queryparser.xml.builders.SpanFirstBuilder;
import org.apache.lucene.queryparser.xml.builders.SpanNearBuilder;
import org.apache.lucene.queryparser.xml.builders.SpanNotBuilder;
import org.apache.lucene.queryparser.xml.builders.SpanOrBuilder;
import org.apache.lucene.queryparser.xml.builders.SpanOrTermsBuilder;
import org.apache.lucene.queryparser.xml.builders.SpanQueryBuilder;
import org.apache.lucene.queryparser.xml.builders.SpanQueryBuilderFactory;
import org.apache.lucene.queryparser.xml.builders.SpanTermBuilder;
import org.apache.lucene.queryparser.xml.builders.TermQueryBuilder;
import org.apache.lucene.queryparser.xml.builders.TermsQueryBuilder;
import org.apache.lucene.queryparser.xml.builders.UserInputQueryBuilder;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CoreParser
implements QueryBuilder,
SpanQueryBuilder {
    protected String defaultField;
    protected Analyzer analyzer;
    protected QueryParser parser;
    protected QueryBuilderFactory queryFactory;
    protected final SpanQueryBuilderFactory spanFactory;

    public CoreParser(Analyzer analyzer, QueryParser parser) {
        this(null, analyzer, parser);
    }

    public CoreParser(String defaultField, Analyzer analyzer) {
        this(defaultField, analyzer, null);
    }

    protected CoreParser(String defaultField, Analyzer analyzer, QueryParser parser) {
        this.defaultField = defaultField;
        this.analyzer = analyzer;
        this.parser = parser;
        this.queryFactory = new QueryBuilderFactory();
        this.spanFactory = new SpanQueryBuilderFactory();
        this.queryFactory.addBuilder("TermQuery", new TermQueryBuilder());
        this.queryFactory.addBuilder("TermsQuery", new TermsQueryBuilder(analyzer));
        this.queryFactory.addBuilder("MatchAllDocsQuery", new MatchAllDocsQueryBuilder());
        this.queryFactory.addBuilder("BooleanQuery", new BooleanQueryBuilder(this.queryFactory));
        this.queryFactory.addBuilder("LegacyNumericRangeQuery", new LegacyNumericRangeQueryBuilder());
        this.queryFactory.addBuilder("PointRangeQuery", new PointRangeQueryBuilder());
        this.queryFactory.addBuilder("RangeQuery", new RangeQueryBuilder());
        this.queryFactory.addBuilder("DisjunctionMaxQuery", new DisjunctionMaxQueryBuilder(this.queryFactory));
        if (parser != null) {
            this.queryFactory.addBuilder("UserQuery", new UserInputQueryBuilder(parser));
        } else {
            this.queryFactory.addBuilder("UserQuery", new UserInputQueryBuilder(defaultField, analyzer));
        }
        this.queryFactory.addBuilder("ConstantScoreQuery", new ConstantScoreQueryBuilder(this.queryFactory));
        SpanNearBuilder snb = new SpanNearBuilder(this.spanFactory);
        this.spanFactory.addBuilder("SpanNear", snb);
        this.queryFactory.addBuilder("SpanNear", snb);
        BoostingTermBuilder btb = new BoostingTermBuilder();
        this.spanFactory.addBuilder("BoostingTermQuery", btb);
        this.queryFactory.addBuilder("BoostingTermQuery", btb);
        SpanTermBuilder snt = new SpanTermBuilder();
        this.spanFactory.addBuilder("SpanTerm", snt);
        this.queryFactory.addBuilder("SpanTerm", snt);
        SpanOrBuilder sot = new SpanOrBuilder(this.spanFactory);
        this.spanFactory.addBuilder("SpanOr", sot);
        this.queryFactory.addBuilder("SpanOr", sot);
        SpanOrTermsBuilder sots = new SpanOrTermsBuilder(analyzer);
        this.spanFactory.addBuilder("SpanOrTerms", sots);
        this.queryFactory.addBuilder("SpanOrTerms", sots);
        SpanFirstBuilder sft = new SpanFirstBuilder(this.spanFactory);
        this.spanFactory.addBuilder("SpanFirst", sft);
        this.queryFactory.addBuilder("SpanFirst", sft);
        SpanNotBuilder snot = new SpanNotBuilder(this.spanFactory);
        this.spanFactory.addBuilder("SpanNot", snot);
        this.queryFactory.addBuilder("SpanNot", snot);
    }

    public Query parse(InputStream xmlStream) throws ParserException {
        return this.getQuery(CoreParser.parseXML(xmlStream).getDocumentElement());
    }

    SpanQuery parseAsSpanQuery(InputStream xmlStream) throws ParserException {
        return this.getSpanQuery(CoreParser.parseXML(xmlStream).getDocumentElement());
    }

    public void addQueryBuilder(String nodeName, QueryBuilder builder) {
        this.queryFactory.addBuilder(nodeName, builder);
    }

    public void addSpanBuilder(String nodeName, SpanQueryBuilder builder) {
        this.spanFactory.addBuilder(nodeName, builder);
    }

    public void addSpanQueryBuilder(String nodeName, SpanQueryBuilder builder) {
        this.queryFactory.addBuilder(nodeName, builder);
        this.spanFactory.addBuilder(nodeName, builder);
    }

    static Document parseXML(InputStream pXmlFile) throws ParserException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (Exception se) {
            throw new ParserException("XML Parser configuration error", se);
        }
        Document doc = null;
        try {
            doc = db.parse(pXmlFile);
        }
        catch (Exception se) {
            throw new ParserException("Error parsing XML stream:" + se, se);
        }
        return doc;
    }

    @Override
    public Query getQuery(Element e) throws ParserException {
        return this.queryFactory.getQuery(e);
    }

    @Override
    public SpanQuery getSpanQuery(Element e) throws ParserException {
        return this.spanFactory.getSpanQuery(e);
    }
}

