/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchWrapperException;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.Index;
import org.elasticsearch.rest.RestStatus;

public final class ExceptionsHelper {
    private static final Logger logger = Loggers.getLogger(ExceptionsHelper.class);
    static final int MAX_ITERATIONS = 1024;

    public static RuntimeException convertToRuntime(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new ElasticsearchException(e);
    }

    public static ElasticsearchException convertToElastic(Exception e) {
        if (e instanceof ElasticsearchException) {
            return (ElasticsearchException)e;
        }
        return new ElasticsearchException(e);
    }

    public static RestStatus status(Throwable t) {
        if (t != null) {
            if (t instanceof ElasticsearchException) {
                return ((ElasticsearchException)t).status();
            }
            if (t instanceof IllegalArgumentException) {
                return RestStatus.BAD_REQUEST;
            }
        }
        return RestStatus.INTERNAL_SERVER_ERROR;
    }

    public static Throwable unwrapCause(Throwable t) {
        int counter = 0;
        Throwable result = t;
        while (result instanceof ElasticsearchWrapperException) {
            if (result.getCause() == null) {
                return result;
            }
            if (result.getCause() == result) {
                return result;
            }
            if (counter++ > 10) {
                logger.warn("Exception cause unwrapping ran for 10 levels...", t);
                return result;
            }
            result = result.getCause();
        }
        return result;
    }

    @Deprecated
    public static String detailedMessage(Throwable t) {
        if (t == null) {
            return "Unknown";
        }
        if (t.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            while (t != null) {
                sb.append(t.getClass().getSimpleName());
                if (t.getMessage() != null) {
                    sb.append("[");
                    sb.append(t.getMessage());
                    sb.append("]");
                }
                sb.append("; ");
                if ((t = t.getCause()) == null) continue;
                sb.append("nested: ");
            }
            return sb.toString();
        }
        return t.getClass().getSimpleName() + "[" + t.getMessage() + "]";
    }

    public static String stackTrace(Throwable e) {
        StringWriter stackTraceStringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stackTraceStringWriter);
        e.printStackTrace(printWriter);
        return stackTraceStringWriter.toString();
    }

    public static String formatStackTrace(StackTraceElement[] stackTrace) {
        return Arrays.stream(stackTrace).skip(1L).map(e -> "\tat " + e).collect(Collectors.joining("\n"));
    }

    public static Optional<Error> maybeError(Throwable cause, Logger logger) {
        if (cause instanceof Error) {
            return Optional.of((Error)cause);
        }
        LinkedList<Throwable> queue = new LinkedList<Throwable>();
        queue.add(cause);
        int iterations = 0;
        while (!queue.isEmpty()) {
            if (++iterations > 1024) {
                logger.warn("giving up looking for fatal errors", cause);
                break;
            }
            Throwable current = (Throwable)queue.remove();
            if (current instanceof Error) {
                return Optional.of((Error)current);
            }
            Collections.addAll(queue, current.getSuppressed());
            if (current.getCause() == null) continue;
            queue.add(current.getCause());
        }
        return Optional.empty();
    }

    public static <T extends Throwable> void rethrowAndSuppress(List<T> exceptions) throws T {
        Throwable main = null;
        for (Throwable ex : exceptions) {
            main = ExceptionsHelper.useOrSuppress(main, ex);
        }
        if (main != null) {
            throw main;
        }
    }

    public static <T extends Throwable> void maybeThrowRuntimeAndSuppress(List<T> exceptions) {
        Throwable main = null;
        for (Throwable ex : exceptions) {
            main = ExceptionsHelper.useOrSuppress(main, ex);
        }
        if (main != null) {
            throw new ElasticsearchException(main);
        }
    }

    public static <T extends Throwable> T useOrSuppress(T first, T second) {
        if (first == null) {
            return second;
        }
        first.addSuppressed(second);
        return first;
    }

    public static IOException unwrapCorruption(Throwable t) {
        return (IOException)ExceptionsHelper.unwrap(t, CorruptIndexException.class, IndexFormatTooOldException.class, IndexFormatTooNewException.class);
    }

    public static Throwable unwrap(Throwable t, Class<?> ... clazzes) {
        if (t != null) {
            do {
                for (Class<?> clazz : clazzes) {
                    if (!clazz.isInstance(t)) continue;
                    return t;
                }
            } while ((t = t.getCause()) != null);
        }
        return null;
    }

    public static boolean reThrowIfNotNull(@Nullable Throwable e) {
        if (e != null) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return true;
    }

    public static ShardOperationFailedException[] groupBy(ShardOperationFailedException[] failures) {
        ArrayList<ShardOperationFailedException> uniqueFailures = new ArrayList<ShardOperationFailedException>();
        HashSet<GroupBy> reasons = new HashSet<GroupBy>();
        for (ShardOperationFailedException failure : failures) {
            GroupBy reason = new GroupBy(failure.getCause());
            if (reasons.contains(reason)) continue;
            reasons.add(reason);
            uniqueFailures.add(failure);
        }
        return uniqueFailures.toArray(new ShardOperationFailedException[0]);
    }

    static class GroupBy {
        final String reason;
        final String index;
        final Class<? extends Throwable> causeType;

        GroupBy(Throwable t) {
            Index index;
            this.index = t instanceof ElasticsearchException ? ((index = ((ElasticsearchException)t).getIndex()) != null ? index.getName() : null) : null;
            this.reason = t.getMessage();
            this.causeType = t.getClass();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupBy groupBy = (GroupBy)o;
            if (!this.causeType.equals(groupBy.causeType)) {
                return false;
            }
            if (this.index != null ? !this.index.equals(groupBy.index) : groupBy.index != null) {
                return false;
            }
            return !(this.reason != null ? !this.reason.equals(groupBy.reason) : groupBy.reason != null);
        }

        public int hashCode() {
            int result = this.reason != null ? this.reason.hashCode() : 0;
            result = 31 * result + (this.index != null ? this.index.hashCode() : 0);
            result = 31 * result + this.causeType.hashCode();
            return result;
        }
    }
}

