/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class JsonProcessor
extends AbstractProcessor {
    public static final String TYPE = "json";
    private final String field;
    private final String targetField;
    private final boolean addToRoot;

    JsonProcessor(String tag, String field, String targetField, boolean addToRoot) {
        super(tag);
        this.field = field;
        this.targetField = targetField;
        this.addToRoot = addToRoot;
    }

    public String getField() {
        return this.field;
    }

    public String getTargetField() {
        return this.targetField;
    }

    boolean isAddToRoot() {
        return this.addToRoot;
    }

    public void execute(IngestDocument document) throws Exception {
        String stringValue = (String)document.getFieldValue(this.field, String.class);
        try {
            Map mapValue = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)stringValue, (boolean)false);
            if (this.addToRoot) {
                for (Map.Entry entry : mapValue.entrySet()) {
                    document.setFieldValue((String)entry.getKey(), entry.getValue());
                }
            } else {
                document.setFieldValue(this.targetField, (Object)mapValue);
            }
        }
        catch (ElasticsearchParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        public JsonProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)JsonProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readOptionalStringProperty((String)JsonProcessor.TYPE, (String)processorTag, config, (String)"target_field");
            boolean addToRoot = ConfigurationUtils.readBooleanProperty((String)JsonProcessor.TYPE, (String)processorTag, config, (String)"add_to_root", (boolean)false);
            if (addToRoot && targetField != null) {
                throw ConfigurationUtils.newConfigurationException((String)JsonProcessor.TYPE, (String)processorTag, (String)"target_field", (String)"Cannot set a target field while also setting `add_to_root` to true");
            }
            if (targetField == null) {
                targetField = field;
            }
            return new JsonProcessor(processorTag, field, targetField, addToRoot);
        }
    }
}

