/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.lookup.DocLookup;
import org.elasticsearch.search.lookup.FieldsLookup;
import org.elasticsearch.search.lookup.IndexLookup;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public class SearchLookup {
    final DocLookup docMap;
    final SourceLookup sourceLookup;
    final FieldsLookup fieldsLookup;

    public SearchLookup(MapperService mapperService, IndexFieldDataService fieldDataService, @Nullable String[] types) {
        this.docMap = new DocLookup(mapperService, fieldDataService, types);
        this.sourceLookup = new SourceLookup();
        this.fieldsLookup = new FieldsLookup(mapperService, types);
    }

    public LeafSearchLookup getLeafSearchLookup(LeafReaderContext context) {
        return new LeafSearchLookup(context, this.docMap.getLeafDocLookup(context), this.sourceLookup, this.fieldsLookup.getLeafFieldsLookup(context), IndexLookup.getLeafIndexLookup(context), IndexLookup.NAMES);
    }

    public DocLookup doc() {
        return this.docMap;
    }

    public SourceLookup source() {
        return this.sourceLookup;
    }
}

