/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherFactory;
import org.elasticsearch.index.engine.EngineConfig;

public class EngineSearcherFactory
extends SearcherFactory {
    private final EngineConfig engineConfig;

    public EngineSearcherFactory(EngineConfig engineConfig) {
        this.engineConfig = engineConfig;
    }

    public IndexSearcher newSearcher(IndexReader reader, IndexReader previousReader) throws IOException {
        IndexSearcher searcher = super.newSearcher(reader, previousReader);
        searcher.setQueryCache(this.engineConfig.getQueryCache());
        searcher.setQueryCachingPolicy(this.engineConfig.getQueryCachingPolicy());
        searcher.setSimilarity(this.engineConfig.getSimilarity());
        return searcher;
    }
}

