/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shrink;

import java.util.Set;
import java.util.function.IntFunction;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.shrink.ShrinkRequest;
import org.elasticsearch.action.admin.indices.shrink.ShrinkResponse;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaDataCreateIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportShrinkAction
extends TransportMasterNodeAction<ShrinkRequest, ShrinkResponse> {
    private final MetaDataCreateIndexService createIndexService;
    private final Client client;

    @Inject
    public TransportShrinkAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataCreateIndexService createIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(settings, "indices:admin/shrink", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, ShrinkRequest::new);
        this.createIndexService = createIndexService;
        this.client = client;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ShrinkResponse newResponse() {
        return new ShrinkResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(ShrinkRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.getShrinkIndexRequest().index());
    }

    @Override
    protected void masterOperation(final ShrinkRequest shrinkRequest, final ClusterState state, final ActionListener<ShrinkResponse> listener) {
        final String sourceIndex = this.indexNameExpressionResolver.resolveDateMathExpression(shrinkRequest.getSourceIndex());
        this.client.admin().indices().prepareStats(sourceIndex).clear().setDocs(true).execute(new ActionListener<IndicesStatsResponse>(){

            @Override
            public void onResponse(IndicesStatsResponse indicesStatsResponse) {
                CreateIndexClusterStateUpdateRequest updateRequest = TransportShrinkAction.prepareCreateIndexRequest(shrinkRequest, state, i -> {
                    IndexShardStats shard = indicesStatsResponse.getIndex(sourceIndex).getIndexShards().get(i);
                    return shard == null ? null : shard.getPrimary().getDocs();
                }, TransportShrinkAction.this.indexNameExpressionResolver);
                TransportShrinkAction.this.createIndexService.createIndex(updateRequest, ActionListener.wrap(response -> listener.onResponse(new ShrinkResponse(response.isAcknowledged(), response.isShardsAcked(), updateRequest.index())), listener::onFailure));
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    static CreateIndexClusterStateUpdateRequest prepareCreateIndexRequest(ShrinkRequest shrinkRequest, ClusterState state, IntFunction<DocsStats> perShardDocStats, IndexNameExpressionResolver indexNameExpressionResolver) {
        String sourceIndex = indexNameExpressionResolver.resolveDateMathExpression(shrinkRequest.getSourceIndex());
        CreateIndexRequest targetIndex = shrinkRequest.getShrinkIndexRequest();
        String targetIndexName = indexNameExpressionResolver.resolveDateMathExpression(targetIndex.index());
        IndexMetaData metaData = state.metaData().index(sourceIndex);
        Settings targetIndexSettings = Settings.builder().put(targetIndex.settings()).normalizePrefix("index.").build();
        int numShards = 1;
        if (IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings)) {
            numShards = IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings);
        }
        for (int i = 0; i < numShards; ++i) {
            Set<ShardId> shardIds = IndexMetaData.selectShrinkShards(i, metaData, numShards);
            long count = 0L;
            for (ShardId id : shardIds) {
                DocsStats docsStats = perShardDocStats.apply(id.id());
                if (docsStats != null) {
                    count += docsStats.getCount();
                }
                if (count <= 0x7FFFFF7FL) continue;
                throw new IllegalStateException("Can't merge index with more than [2147483519] docs - too many documents in shards " + shardIds);
            }
        }
        if (IndexMetaData.INDEX_ROUTING_PARTITION_SIZE_SETTING.exists(targetIndexSettings)) {
            throw new IllegalArgumentException("cannot provide a routing partition size value when shrinking an index");
        }
        targetIndex.cause("shrink_index");
        Settings.Builder settingsBuilder = Settings.builder().put(targetIndexSettings);
        settingsBuilder.put("index.number_of_shards", numShards);
        targetIndex.settings(settingsBuilder);
        return ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(targetIndex, "shrink_index", targetIndex.index(), targetIndexName, true).ackTimeout(targetIndex.timeout())).masterNodeTimeout(targetIndex.masterNodeTimeout())).settings(targetIndex.settings()).aliases(targetIndex.aliases()).customs(targetIndex.customs()).waitForActiveShards(targetIndex.waitForActiveShards()).shrinkFrom(metaData.getIndex());
    }
}

