/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.relate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.EdgeIntersectionList;
import com.vividsolutions.jts.geomgraph.Label;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EdgeEndBuilder {
    public List computeEdgeEnds(Iterator edges) {
        ArrayList l = new ArrayList();
        Iterator i = edges;
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            this.computeEdgeEnds(e, l);
        }
        return l;
    }

    public void computeEdgeEnds(Edge edge, List l) {
        EdgeIntersectionList eiList = edge.getEdgeIntersectionList();
        eiList.addEndpoints();
        Iterator it = eiList.iterator();
        EdgeIntersection eiPrev = null;
        EdgeIntersection eiCurr = null;
        if (!it.hasNext()) {
            return;
        }
        EdgeIntersection eiNext = (EdgeIntersection)it.next();
        do {
            eiPrev = eiCurr;
            eiCurr = eiNext;
            eiNext = null;
            if (it.hasNext()) {
                eiNext = (EdgeIntersection)it.next();
            }
            if (eiCurr == null) continue;
            this.createEdgeEndForPrev(edge, l, eiCurr, eiPrev);
            this.createEdgeEndForNext(edge, l, eiCurr, eiNext);
        } while (eiCurr != null);
    }

    void createEdgeEndForPrev(Edge edge, List l, EdgeIntersection eiCurr, EdgeIntersection eiPrev) {
        int iPrev = eiCurr.segmentIndex;
        if (eiCurr.dist == 0.0) {
            if (iPrev == 0) {
                return;
            }
            --iPrev;
        }
        Coordinate pPrev = edge.getCoordinate(iPrev);
        if (eiPrev != null && eiPrev.segmentIndex >= iPrev) {
            pPrev = eiPrev.coord;
        }
        Label label = new Label(edge.getLabel());
        label.flip();
        EdgeEnd e = new EdgeEnd(edge, eiCurr.coord, pPrev, label);
        l.add(e);
    }

    void createEdgeEndForNext(Edge edge, List l, EdgeIntersection eiCurr, EdgeIntersection eiNext) {
        int iNext = eiCurr.segmentIndex + 1;
        if (iNext >= edge.getNumPoints() && eiNext == null) {
            return;
        }
        Coordinate pNext = edge.getCoordinate(iNext);
        if (eiNext != null && eiNext.segmentIndex == eiCurr.segmentIndex) {
            pNext = eiNext.coord;
        }
        EdgeEnd e = new EdgeEnd(edge, eiCurr.coord, pNext, new Label(edge.getLabel()));
        l.add(e);
    }
}

