/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.TemplateService;
import org.elasticsearch.ingest.common.FailProcessorException;

public final class FailProcessor
extends AbstractProcessor {
    public static final String TYPE = "fail";
    private final TemplateService.Template message;

    FailProcessor(String tag, TemplateService.Template message) {
        super(tag);
        this.message = message;
    }

    public TemplateService.Template getMessage() {
        return this.message;
    }

    public void execute(IngestDocument document) {
        throw new FailProcessorException(document.renderTemplate(this.message));
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        private final TemplateService templateService;

        public Factory(TemplateService templateService) {
            this.templateService = templateService;
        }

        public FailProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String message = ConfigurationUtils.readStringProperty((String)FailProcessor.TYPE, (String)processorTag, config, (String)"message");
            TemplateService.Template compiledTemplate = ConfigurationUtils.compileTemplate((String)FailProcessor.TYPE, (String)processorTag, (String)"message", (String)message, (TemplateService)this.templateService);
            return new FailProcessor(processorTag, compiledTemplate);
        }
    }
}

