/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.common.Grok;

public final class GrokProcessor
extends AbstractProcessor {
    public static final String TYPE = "grok";
    private static final String PATTERN_MATCH_KEY = "_ingest._grok_match_index";
    private final String matchField;
    private final List<String> matchPatterns;
    private final Grok grok;
    private final boolean traceMatch;
    private final boolean ignoreMissing;

    public GrokProcessor(String tag, Map<String, String> patternBank, List<String> matchPatterns, String matchField, boolean traceMatch, boolean ignoreMissing) {
        super(tag);
        this.matchField = matchField;
        this.matchPatterns = matchPatterns;
        this.grok = new Grok(patternBank, GrokProcessor.combinePatterns(matchPatterns, traceMatch));
        this.traceMatch = traceMatch;
        this.ignoreMissing = ignoreMissing;
    }

    public void execute(IngestDocument ingestDocument) throws Exception {
        String fieldValue = (String)ingestDocument.getFieldValue(this.matchField, String.class, this.ignoreMissing);
        if (fieldValue == null && this.ignoreMissing) {
            return;
        }
        if (fieldValue == null) {
            throw new IllegalArgumentException("field [" + this.matchField + "] is null, cannot process it.");
        }
        Map<String, Object> matches = this.grok.captures(fieldValue);
        if (matches == null) {
            throw new IllegalArgumentException("Provided Grok expressions do not match field value: [" + fieldValue + "]");
        }
        matches.entrySet().stream().forEach(e -> ingestDocument.setFieldValue((String)e.getKey(), e.getValue()));
        if (this.traceMatch) {
            if (this.matchPatterns.size() > 1) {
                HashMap matchMap = (HashMap)ingestDocument.getFieldValue(PATTERN_MATCH_KEY, Object.class);
                matchMap.keySet().stream().findFirst().ifPresent(index -> ingestDocument.setFieldValue(PATTERN_MATCH_KEY, index));
            } else {
                ingestDocument.setFieldValue(PATTERN_MATCH_KEY, (Object)"0");
            }
        }
    }

    public String getType() {
        return TYPE;
    }

    Grok getGrok() {
        return this.grok;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    String getMatchField() {
        return this.matchField;
    }

    List<String> getMatchPatterns() {
        return this.matchPatterns;
    }

    static String combinePatterns(List<String> patterns, boolean traceMatch) {
        String combinedPattern;
        if (patterns.size() > 1) {
            combinedPattern = "";
            for (int i = 0; i < patterns.size(); ++i) {
                String pattern = patterns.get(i);
                String valueWrap = traceMatch ? "(?<_ingest._grok_match_index." + i + ">" + pattern + ")" : "(?:" + patterns.get(i) + ")";
                combinedPattern = combinedPattern.equals("") ? valueWrap : combinedPattern + "|" + valueWrap;
            }
        } else {
            combinedPattern = patterns.get(0);
        }
        return combinedPattern;
    }

    public static final class Factory
    implements Processor.Factory {
        private final Map<String, String> builtinPatterns;

        public Factory(Map<String, String> builtinPatterns) {
            this.builtinPatterns = builtinPatterns;
        }

        public GrokProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String matchField = ConfigurationUtils.readStringProperty((String)GrokProcessor.TYPE, (String)processorTag, config, (String)"field");
            List matchPatterns = ConfigurationUtils.readList((String)GrokProcessor.TYPE, (String)processorTag, config, (String)"patterns");
            boolean traceMatch = ConfigurationUtils.readBooleanProperty((String)GrokProcessor.TYPE, (String)processorTag, config, (String)"trace_match", (boolean)false);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)GrokProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            if (matchPatterns.isEmpty()) {
                throw ConfigurationUtils.newConfigurationException((String)GrokProcessor.TYPE, (String)processorTag, (String)"patterns", (String)"List of patterns must not be empty");
            }
            Map customPatternBank = ConfigurationUtils.readOptionalMap((String)GrokProcessor.TYPE, (String)processorTag, config, (String)"pattern_definitions");
            HashMap<String, String> patternBank = new HashMap<String, String>(this.builtinPatterns);
            if (customPatternBank != null) {
                patternBank.putAll(customPatternBank);
            }
            try {
                return new GrokProcessor(processorTag, patternBank, matchPatterns, matchField, traceMatch, ignoreMissing);
            }
            catch (Exception e) {
                throw ConfigurationUtils.newConfigurationException((String)GrokProcessor.TYPE, (String)processorTag, (String)"patterns", (String)("Invalid regex pattern found in: " + matchPatterns + ". " + e.getMessage()));
            }
        }
    }
}

