/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.ScriptInterface;

public final class Locals {
    public static final String LOOP = "#loop";
    public static final String THIS = "#this";
    public static final Set<String> KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("#this", "#loop")));
    private final Definition definition;
    private final Locals parent;
    private final Definition.Type returnType;
    private final Set<String> keywords;
    private int nextSlotNumber;
    private Map<String, Variable> variables;
    private Map<Definition.MethodKey, Definition.Method> methods;

    public static Locals newLocalScope(Locals currentScope) {
        return new Locals(currentScope);
    }

    public static Locals newLambdaScope(Locals programScope, Definition.Type returnType, List<Parameter> parameters, int captureCount, int maxLoopCounter) {
        Locals locals = new Locals(programScope, programScope.definition, returnType, KEYWORDS);
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = parameters.get(i);
            boolean isCapture = true;
            locals.addVariable(parameter.location, parameter.type, parameter.name, isCapture);
        }
        if (maxLoopCounter > 0) {
            locals.defineVariable(null, Definition.INT_TYPE, LOOP, true);
        }
        return locals;
    }

    public static Locals newFunctionScope(Locals programScope, Definition.Type returnType, List<Parameter> parameters, int maxLoopCounter) {
        Locals locals = new Locals(programScope, programScope.definition, returnType, KEYWORDS);
        for (Parameter parameter : parameters) {
            locals.addVariable(parameter.location, parameter.type, parameter.name, false);
        }
        if (maxLoopCounter > 0) {
            locals.defineVariable(null, Definition.INT_TYPE, LOOP, true);
        }
        return locals;
    }

    public static Locals newMainMethodScope(ScriptInterface scriptInterface, Locals programScope, int maxLoopCounter) {
        Locals locals = new Locals(programScope, programScope.definition, scriptInterface.getExecuteMethodReturnType(), KEYWORDS);
        locals.defineVariable(null, programScope.definition.getType("Object"), THIS, true);
        for (ScriptInterface.MethodArgument arg : scriptInterface.getExecuteArguments()) {
            locals.defineVariable(null, arg.getType(), arg.getName(), true);
        }
        if (maxLoopCounter > 0) {
            locals.defineVariable(null, Definition.INT_TYPE, LOOP, true);
        }
        return locals;
    }

    public static Locals newProgramScope(Definition definition, Collection<Definition.Method> methods) {
        Locals locals = new Locals(null, definition, null, null);
        for (Definition.Method method : methods) {
            locals.addMethod(method);
        }
        return locals;
    }

    public boolean hasVariable(String name) {
        Variable variable = this.lookupVariable(null, name);
        if (variable != null) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.hasVariable(name);
        }
        return false;
    }

    public Variable getVariable(Location location, String name) {
        Variable variable = this.lookupVariable(location, name);
        if (variable != null) {
            return variable;
        }
        if (this.parent != null) {
            return this.parent.getVariable(location, name);
        }
        throw location.createError(new IllegalArgumentException("Variable [" + name + "] is not defined."));
    }

    public Definition.Method getMethod(Definition.MethodKey key) {
        Definition.Method method = this.lookupMethod(key);
        if (method != null) {
            return method;
        }
        if (this.parent != null) {
            return this.parent.getMethod(key);
        }
        return null;
    }

    public Variable addVariable(Location location, Definition.Type type, String name, boolean readonly) {
        if (this.hasVariable(name)) {
            throw location.createError(new IllegalArgumentException("Variable [" + name + "] is already defined."));
        }
        if (this.keywords.contains(name)) {
            throw location.createError(new IllegalArgumentException("Variable [" + name + "] is reserved."));
        }
        return this.defineVariable(location, type, name, readonly);
    }

    public Definition.Type getReturnType() {
        return this.returnType;
    }

    public Locals getProgramScope() {
        Locals locals = this;
        while (locals.getParent() != null) {
            locals = locals.getParent();
        }
        return locals;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    private Locals(Locals parent) {
        this(parent, parent.definition, parent.returnType, parent.keywords);
    }

    private Locals(Locals parent, Definition definition, Definition.Type returnType, Set<String> keywords) {
        this.parent = parent;
        this.definition = definition;
        this.returnType = returnType;
        this.keywords = keywords;
        this.nextSlotNumber = parent == null ? 0 : parent.getNextSlot();
    }

    private Locals getParent() {
        return this.parent;
    }

    private Variable lookupVariable(Location location, String name) {
        if (this.variables == null) {
            return null;
        }
        return this.variables.get(name);
    }

    private Definition.Method lookupMethod(Definition.MethodKey key) {
        if (this.methods == null) {
            return null;
        }
        return this.methods.get(key);
    }

    private Variable defineVariable(Location location, Definition.Type type, String name, boolean readonly) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Variable>();
        }
        Variable variable = new Variable(location, name, type, this.getNextSlot(), readonly);
        this.variables.put(name, variable);
        this.nextSlotNumber += type.type.getSize();
        return variable;
    }

    private void addMethod(Definition.Method method) {
        if (this.methods == null) {
            this.methods = new HashMap<Definition.MethodKey, Definition.Method>();
        }
        this.methods.put(new Definition.MethodKey(method.name, method.arguments.size()), method);
    }

    private int getNextSlot() {
        return this.nextSlotNumber;
    }

    public static final class Parameter {
        public final Location location;
        public final String name;
        public final Definition.Type type;

        public Parameter(Location location, String name, Definition.Type type) {
            this.location = location;
            this.name = name;
            this.type = type;
        }
    }

    public static final class Variable {
        public final Location location;
        public final String name;
        public final Definition.Type type;
        public final boolean readonly;
        private final int slot;

        public Variable(Location location, String name, Definition.Type type, int slot, boolean readonly) {
            this.location = location;
            this.name = name;
            this.type = type;
            this.slot = slot;
            this.readonly = readonly;
        }

        public int getSlot() {
            return this.slot;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("Variable[type=").append(this.type);
            b.append(",name=").append(this.name);
            b.append(",slot=").append(this.slot);
            if (this.readonly) {
                b.append(",readonly");
            }
            b.append(']');
            return b.toString();
        }
    }
}

