/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.smb;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.OutputStreamIndexOutput;

public final class SmbDirectoryWrapper
extends FilterDirectory {
    private final FSDirectory fsDirectory;

    public SmbDirectoryWrapper(FSDirectory in) {
        super((Directory)in);
        this.fsDirectory = in;
    }

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        return new SmbFSIndexOutput(name);
    }

    public Set<String> getPendingDeletions() throws IOException {
        return this.in.getPendingDeletions();
    }

    final class SmbFSIndexOutput
    extends OutputStreamIndexOutput {
        static final int CHUNK_SIZE = 8192;

        SmbFSIndexOutput(String name) throws IOException {
            super("SmbFSIndexOutput(path=\"" + SmbDirectoryWrapper.this.fsDirectory.getDirectory().resolve(name) + "\")", name, (OutputStream)new FilterOutputStream(Channels.newOutputStream(Files.newByteChannel(SmbDirectoryWrapper.this.fsDirectory.getDirectory().resolve(name), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.READ, StandardOpenOption.WRITE))){

                @Override
                public void write(byte[] b, int offset, int length) throws IOException {
                    while (length > 0) {
                        int chunk = Math.min(length, 8192);
                        this.out.write(b, offset, chunk);
                        length -= chunk;
                        offset += chunk;
                    }
                }
            }, 8192);
        }
    }
}

